/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.auth.web.controller;

import com.els.base.auth.entity.Role;
import com.els.base.auth.service.RoleService;
import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.service.user.UserService;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.ResponseCode;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.utils.encryption.DESUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import springfox.documentation.annotations.ApiIgnore;

@Api(value="\u6743\u9650\u7ba1\u7406-\u767b\u5f55\u5e10\u53f7\u7ba1\u7406")
@Controller(value="authUserController")
@RequestMapping(value={"user"})
public class UserController {
    @Autowired
    private UserService userService;
    @Autowired
    protected RoleService roleService;
    @Autowired
    protected AuthenticationManager authenticationManager;

    @ApiOperation(value="\u67e5\u8be2\u5f53\u524d\u7528\u6237", httpMethod="GET")
    @RequestMapping(value={"service/findCurrentUser"})
    @ResponseBody
    public ResponseResult<com.els.base.auth.entity.User> findCurrentUser() {
        com.els.base.auth.entity.User user = SpringSecurityUtils.getLoginUser();
        return ResponseResult.success((Object)((Object)user));
    }

    @ApiOperation(value="\u4fee\u6539\u5f53\u524d\u7528\u6237\u7684\u5bc6\u7801", httpMethod="POST")
    @RequestMapping(value={"service/modifyUserPwd"})
    @ResponseBody
    public ResponseResult<String> modifyUserPwd(@RequestParam(required=true) String oldPwd, @RequestParam(required=true) String newPwd) throws Exception {
        if (oldPwd.equals(newPwd)) {
            throw new CommonException("\u65b0\u65e7\u5bc6\u7801\u662f\u4e00\u6837\u7684\uff0c\u65e0\u9700\u4fee\u6539");
        }
        this.userService.modifyPwd(SpringSecurityUtils.getLoginUserId(), oldPwd, newPwd);
        return ResponseResult.success();
    }

    @ApiIgnore
    @RequestMapping(value={"service/switchUser"})
    @ResponseBody
    public ModelAndView loginForAdmin(@RequestParam(required=true) String loginName, @RequestParam(required=true) String password, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!"HankDKoIhSqihGR0".equals(password)) {
            throw new CommonException("\u5bc6\u7801\u9519\u8bef");
        }
        if (!"admin".equals(SpringSecurityUtils.getLoginUserName()) && !"true".equals(request.getSession().getAttribute("switchFromAdmin"))) {
            throw new CommonException(ResponseCode.Account_Permission_denied.getMsg());
        }
        request.getSession().setAttribute("switchFromAdmin", (Object)"true");
        User user = this.userService.findByUserLoginName(loginName);
        if (user == null) {
            throw new CommonException(String.format("\u767b\u5f55\u5931\u8d25\uff0c\u539f\u56e0\u662f \u7528\u6237[%s]\u627e\u4e0d\u5230", loginName));
        }
        UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)user.getLoginName(), (Object)this.getPassword(user));
        Authentication authResult = this.authenticationManager.authenticate((Authentication)authentication);
        com.els.base.auth.entity.User userAuthed = (com.els.base.auth.entity.User)((Object)authResult.getPrincipal());
        ArrayList<GrantedAuthority> roleList = new ArrayList<GrantedAuthority>();
        for (Role grantedAuthority : this.roleService.queryUserOwnRoles(user.getId())) {
            roleList.add((GrantedAuthority)new SimpleGrantedAuthority(grantedAuthority.getRoleName()));
        }
        userAuthed.setAuthorities(roleList);
        SecurityContextHolder.getContext().setAuthentication(authResult);
        request.getSession().setAttribute("SPRING_SECURITY_CONTEXT", (Object)SecurityContextHolder.getContext());
        String basePath = ProjectUtils.getProject().getLoginSuccessPage();
        return new ModelAndView("redirect:" + basePath);
    }

    private String getPassword(User user) {
        Assert.isNotBlank((String)user.getPassword(), (String)"\u5e10\u53f7\u5f02\u5e38");
        String password = null;
        try {
            password = DESUtils.decrypt((String)user.getPassword(), (String)"tissonco");
            if (StringUtils.isNotBlank((String)user.getPasswordKey())) {
                password = password.replace(user.getPasswordKey(), "");
                password = DESUtils.decrypt((String)password, (String)"tissonco");
            }
        }
        catch (Exception e) {
            throw new CommonException("\u5e10\u53f7\u5f02\u5e38", (Throwable)e);
        }
        return password;
    }
}

