package com.els.base.auth.entity;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(value="菜单")
public class Menu implements Serializable, AuthorizationData {

    //	############################
    public static final String ROOT_ID = "1";
    private boolean authorized = true;

    @ApiModelProperty("按钮列表")
    private List<Button> buttonList;

    public List<Button> getButtonList() {
        return buttonList;
    }

    public void setButtonList(List<Button> buttonList) {
        this.buttonList = buttonList;
    }

    @ApiModelProperty("请求url列表")
    private List<Operator> operatorList;

    public List<Operator> getOperatorList() {
        return operatorList;
    }

    public void setOperatorList(List<Operator> operatorList) {
        this.operatorList = operatorList;
    }

//	@ApiModelProperty("页面下的授权的元素")
//	private Map<String, List<AuthorizationData>> authorizations;
//
//	public Map<String, List<AuthorizationData>> getAuthorizations() {
//		return authorizations;
//	}
//
//	public void setAuthorizations(Map<String, List<AuthorizationData>> authorizations) {
//		this.authorizations = authorizations;
//	}
    @JsonProperty("list")
    private List<Menu> children;

    public boolean getAuthorized() {
        return authorized;
    }

    public void setAuthorized(boolean authorized) {
        this.authorized = authorized;
    }

    public List<Menu> getChildren() {
        return children;
    }

    public void setChildren(List<Menu> children) {
        this.children = children;
    }

    @Override
    public String getType() {
    	return this.getMenuType();
    }
    
    @ApiModelProperty("菜单提示")
    private String tip;

    public String getTip() {
		return tip;
	}

	public void setTip(String tip) {
		this.tip = tip;
	}
//	############################

	@ApiModelProperty("菜单Id")
    private String id;

    @ApiModelProperty("父类菜单Id")
    private String parentId;

    @ApiModelProperty("菜单类型：菜单组module，菜单menu")
    private String menuType;

    @ApiModelProperty("菜单名称")
    @JsonProperty("name")
    private String menuName;

    @ApiModelProperty("菜单栏目代码")
    private String menuCode;

    @ApiModelProperty(value="菜单请求地址",name="path")
    @JsonProperty("path")
    private String menuUrl;

    @ApiModelProperty("菜单排序号")
    private Integer sortNo;

    @ApiModelProperty("插入时间")
    private Date createTime;

    @ApiModelProperty("更新日期")
    private Date updateTime;

    @ApiModelProperty("菜单logo图标")
    @JsonProperty("ico")
    private String menuLogo;

    @ApiModelProperty("菜单名称描述")
    private String menuDesc;

    private static final long serialVersionUID = 1L;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getParentId() {
        return parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId == null ? null : parentId.trim();
    }

    public String getMenuType() {
        return menuType;
    }

    public void setMenuType(String menuType) {
        this.menuType = menuType == null ? null : menuType.trim();
    }

    public String getMenuName() {
        return menuName;
    }

    public void setMenuName(String menuName) {
        this.menuName = menuName == null ? null : menuName.trim();
    }

    public String getMenuCode() {
        return menuCode;
    }

    public void setMenuCode(String menuCode) {
        this.menuCode = menuCode == null ? null : menuCode.trim();
    }

    public String getMenuUrl() {
        return menuUrl;
    }

    public void setMenuUrl(String menuUrl) {
        this.menuUrl = menuUrl == null ? null : menuUrl.trim();
    }

    public Integer getSortNo() {
        return sortNo;
    }

    public void setSortNo(Integer sortNo) {
        this.sortNo = sortNo;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public String getMenuLogo() {
        return menuLogo;
    }

    public void setMenuLogo(String menuLogo) {
        this.menuLogo = menuLogo == null ? null : menuLogo.trim();
    }

    public String getMenuDesc() {
        return menuDesc;
    }

    public void setMenuDesc(String menuDesc) {
        this.menuDesc = menuDesc == null ? null : menuDesc.trim();
    }
}