package com.els.base.auth.plugin;

import java.util.Properties;

import javax.annotation.PostConstruct;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import com.google.code.kaptcha.impl.DefaultKaptcha;
import com.google.code.kaptcha.util.Config;

@Component
public class CaptchaProducer extends DefaultKaptcha {
	
	@Value("${auth.captcha.width:100}")
	private String width;
	
	@Value("${auth.captcha.height:60}")
	private String height;
	
	@Value("${auth.captcha.random.str:0123456789}")
	private String randomStr;
	
	@Value("${auth.captcha.length:4}")
	private String length;
	
	
	@PostConstruct
	private void init(){
		Properties properties = new Properties();
		properties.setProperty("kaptcha.image.width", this.width);
		properties.setProperty("kaptcha.image.height", this.height);
		properties.setProperty("kaptcha.textproducer.char.string", this.randomStr);
		properties.setProperty("kaptcha.textproducer.char.length", this.length);
		
		Config config = new Config(properties);
		this.setConfig(config);
		
	}

}
