package com.els.base.auth.service;

import java.util.List;

import com.els.base.auth.entity.Menu;
import com.els.base.auth.entity.MenuExample;
import com.els.base.core.service.BaseService;

public interface MenuService extends BaseService<Menu, MenuExample, String> {

    /**
     * 根据角色id，查询所有的菜单，并带上菜单的授权信息
     * @param roleIds
     * @return
     */
	List<Menu> queryAllMenuWithAuthRoleIds(List<String> loginUserRoleIdList, List<String> roleIds, String menuType);

	/**
	 * 根据角色id,查询已经授权的菜单
	 * @param roleIds
	 * @return
	 */
	List<Menu> queryAuthedMenuForRoleIds(List<String> roleId, String menuType);

	/**
	 * 查询菜单下的提示语
	 * @param roleId
	 * @return
	 */
	List<Menu> queryMenuTip(List<String> roleId, String menuType);
}
