package com.els.base.auth.service;

import java.util.List;

import com.els.base.auth.entity.Role;
import com.els.base.auth.entity.RoleRight;
import com.els.base.auth.entity.RoleRightExample;
import com.els.base.core.service.BaseService;

/**
 * Created by LiBing on 2014-07-22  17:44
 */
public interface RoleRightService extends BaseService<RoleRight, RoleRightExample, String> {

    public void deleteByExample(RoleRightExample example);
    
    /**
     * 查询该url请求分配给那些角色
     * @param url
     * @return
     */
    public List<Role> getRoleByOperatorUrl(String url);

    /**
     * 授权到角色
     * @param roleId
     * @param rights
     */
	public void authorized(String roleId, List<RoleRight> rights);
	
	/**
	 * 授权到角色
	 * @param roleId
	 * @param rights
	 */
	public void authorized(String roleId, List<RoleRight> rights, String menuType);
	
}
