package com.els.base.auth.service.impl;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Component;

import com.els.base.auth.entity.Role;
import com.els.base.auth.service.RoleService;
import com.els.base.core.service.user.UserExtInfoQueryService;

/**
 * 给用户的拓展信息角色
 * @author hzy
 *
 */
@Component
public class QueryRoleForUser implements UserExtInfoQueryService<ArrayList<Role>> {
	
	@Resource
	protected RoleService roleService;

	@Override
	public String getExtKey() {
		return "roleList";
	}

	@Override
	public ArrayList<Role> getData(String userId) {
		List<Role> list = roleService.queryUserOwnRoles(userId);
		
		ArrayList<Role> roleList = new ArrayList<>();
		if (CollectionUtils.isNotEmpty(list)) {
			roleList.addAll(list);
		}
		return roleList;
	}

}
