package com.els.base.auth.utils;

import com.els.base.auth.entity.Role;

/**
 * 授权用的常量
 * @author hzy
 *
 */
public class AuthConstant {
	
	/**系统匿名角色编码**/
	public static final String ANONYMOUS_ROLE_CODE = "SYS_ANONYMOUS_ROLE";
	
	/**系统匿名角色**/
	public static final Role ANONYMOUS_ROLE = new Role("-200", "系统匿名角色", 0, ANONYMOUS_ROLE_CODE);
	
	/**系统默认角色编码**/
	public static final String DEFAULT_ROLE_CODE = "SYS_DEFAULT_ROLE";
	
	/**系统默认角色**/
	public static final Role DEFAULT_ROLE = new Role("-100", "系统匿名角色", 0, "SYS_DEFAULT_ROLE");
	
	/**系统管理员角色**/
	public static final Role SYS_MANAGER_ROLE = new Role("1", "系统管理员", 0, "systemManager");
	
	/**随机验证码的session key**/
	public static final String CAPTCHA_KEY = "captcha";
}
