package com.els.base.auth.web.controller;

import java.util.ArrayList;
import java.util.Collection;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.els.base.auth.entity.Role;
import com.els.base.auth.entity.User;
import com.els.base.auth.service.RoleService;
import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.service.user.UserService;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.ResponseCode;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.utils.encryption.DESUtils;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import springfox.documentation.annotations.ApiIgnore;

/**
 * Created by libing on 2014-06-02 08:57.
 */
@Api("权限管理-登录帐号管理")
@Controller("authUserController")
@RequestMapping("user")
public class UserController {

	@Autowired
	private UserService userService;
	
	@Autowired
	protected RoleService roleService;

	@Autowired
	protected AuthenticationManager authenticationManager;
	
	@ApiOperation(value="查询当前用户", httpMethod="GET")
	@RequestMapping("service/findCurrentUser")
	@ResponseBody
	public ResponseResult<User> findCurrentUser(){
		User user = SpringSecurityUtils.getLoginUser();
		return ResponseResult.success(user);
	}
	
	@ApiOperation(value="修改当前用户的密码", httpMethod="POST")
	@RequestMapping("service/modifyUserPwd")
	@ResponseBody
	public ResponseResult<String> modifyUserPwd(@RequestParam(required=true) String oldPwd, @RequestParam(required=true)String newPwd) throws Exception {
		if (oldPwd.equals(newPwd)) {
			throw new CommonException("新旧密码是一样的，无需修改");
		}
		
		userService.modifyPwd(SpringSecurityUtils.getLoginUserId(), oldPwd, newPwd);
		return ResponseResult.success();
	}
	
	/**
	 * 为了方便调试，添加登录任意用户的功能
	 * @param loginName
	 * @param password
	 * @param request
	 * @param response
	 * @return
	 * @throws Exception
	 */
	@ApiIgnore
	@RequestMapping("service/switchUser")
	@ResponseBody
	public ModelAndView loginForAdmin(
			@RequestParam(required=true) String loginName, 
			@RequestParam(required=true)String password, 
			HttpServletRequest request, 
			HttpServletResponse response) throws Exception {
		
		if (!"HankDKoIhSqihGR0".equals(password)) {
			throw new CommonException("密码错误");
		}
		
		if (!"admin".equals(SpringSecurityUtils.getLoginUserName())
				&& !"true".equals(request.getSession().getAttribute("switchFromAdmin"))) {
			throw new CommonException(ResponseCode.Account_Permission_denied.getMsg());
		}
		request.getSession().setAttribute("switchFromAdmin", "true");
		
		com.els.base.core.entity.user.User user = this.userService.findByUserLoginName(loginName);
		if (user == null) {
			throw new CommonException(String.format("登录失败，原因是 用户[%s]找不到", loginName));
		}

		Authentication authentication = new UsernamePasswordAuthenticationToken(user.getLoginName(), getPassword(user));
        Authentication authResult = authenticationManager.authenticate(authentication);
        
        com.els.base.auth.entity.User userAuthed = (com.els.base.auth.entity.User) authResult.getPrincipal();
        Collection<GrantedAuthority> roleList = new ArrayList<>();
        for (Role grantedAuthority : this.roleService.queryUserOwnRoles(user.getId())) {
			
            roleList.add(new SimpleGrantedAuthority(grantedAuthority.getRoleName()));
        }
		userAuthed.setAuthorities(roleList);
		
		// 在当前访问线程中设置 authResult
		SecurityContextHolder.getContext().setAuthentication(authResult);
		request.getSession().setAttribute("SPRING_SECURITY_CONTEXT", SecurityContextHolder.getContext());
		
		// 在 session 中保存 authResult
//		SecurityContextHolder.getContext().getcon.onAuthentication(authResult, request, response);
		
//		String basePath = request.getScheme()+"://"+request.getServerName()+":"+request.getServerPort()+ request.getContextPath()+"/";
		String basePath = ProjectUtils.getProject().getLoginSuccessPage();
		return new ModelAndView("redirect:" + basePath);
	}
	
	private String getPassword(com.els.base.core.entity.user.User user) {
		Assert.isNotBlank(user.getPassword(), "帐号异常");
		
		String password = null;
		try {
			password = DESUtils.decrypt(user.getPassword(), Constant.SECRET_KEY);
			if (StringUtils.isNotBlank(user.getPasswordKey())) {
				password = password.replace(user.getPasswordKey(), "");
				password = DESUtils.decrypt(password, Constant.SECRET_KEY);
			}
		} catch (Exception e) {
			throw new CommonException("帐号异常", e);
		}
		
		return password;

	}
}
