package com.els.base.auth.web.controller;

import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.els.base.auth.entity.UserGroup;
import com.els.base.auth.entity.UserGroupExample;
import com.els.base.auth.service.UserGroupService;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

@Api(value = "权限管理-用户组")
@Controller
@RequestMapping("userGroup")
public class UserGroupController {
    @Resource
    protected UserGroupService userGroupService;

    @ApiOperation(httpMethod = "POST", value = "创建用户组")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody UserGroup userGroup) {
        this.userGroupService.addObj(userGroup);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "编辑用户组")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody UserGroup userGroup) {
        if (StringUtils.isBlank(userGroup.getId())) {
            throw new CommonException("id为空", "id_is_blank");
        }
        this.userGroupService.modifyObj(userGroup);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "删除用户组")
    @RequestMapping("service/deleteById")
    @ResponseBody
    public ResponseResult<String> deleteById(String id) {
        this.userGroupService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "GET", value = "查询用户组")
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<UserGroup>> findByPage(
            @ApiParam(value = "所在页", defaultValue = "1") @RequestParam(defaultValue = "1") int pageNo,
            @ApiParam(value = "每页数量", defaultValue = "10") @RequestParam(defaultValue = "10") int pageSize,
            @ApiParam(value = "查询条件") String sSearch) {
        PageView<UserGroup> pageView = new PageView<>(pageNo, pageSize);
        UserGroupExample example = new UserGroupExample();
        example.setPageView(pageView);
        if (StringUtils.isNotBlank(sSearch)) {
            // TODO Auto-generated method stub
        }
        PageView<UserGroup> pageData = this.userGroupService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod = "GET", value = "查找用户子分组")
    @RequestMapping("service/findSubUserGroups")
    @ResponseBody
    public ResponseResult<List<UserGroup>> findSubUserGroups(String userGroupId) {

        if (userGroupId == null) {
            UserGroupExample example = new UserGroupExample();
            example.createCriteria().andParentIdIsNull().andIsEnableEqualTo(Constant.YES_INT);
            return ResponseResult.success(this.userGroupService.queryAllObjByExample(example));
        }

        return ResponseResult.success(this.userGroupService.querySubChildren(userGroupId));
    }
}