package com.els.base.auth.web.security.impl;

import java.io.IOException;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

import org.springframework.web.filter.GenericFilterBean;

import com.els.base.auth.exception.InVaildSessionForAnonymousException;

/**
 * 对匿名请求的session过期处理
 * @author hzy
 *
 */
public class InVaildSessionHandlerForAnonymouoseFilter extends GenericFilterBean {

	public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
		try {
			chain.doFilter(req, res);
			
		} catch (InVaildSessionForAnonymousException e) {
			
			// 如果匿名用户因为session 过期，而停止了请求，重新生成session 再执行一次
			HttpServletRequest request = (HttpServletRequest) req;
			request.getSession();
			
			chain.doFilter(req, res);
		}
		
	}
}
