/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.auth.service.impl;

import com.els.base.auth.dao.OperatorMapper;
import com.els.base.auth.dao.RoleMapper;
import com.els.base.auth.dao.RoleRightMapper;
import com.els.base.auth.entity.Operator;
import com.els.base.auth.entity.OperatorExample;
import com.els.base.auth.entity.Role;
import com.els.base.auth.entity.RoleExample;
import com.els.base.auth.entity.RoleRight;
import com.els.base.auth.entity.RoleRightExample;
import com.els.base.auth.service.MenuService;
import com.els.base.auth.service.RoleRightService;
import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RoleRightServiceImpl
implements RoleRightService {
    @Resource
    protected MenuService menuService;
    @Resource
    private RoleRightMapper roleRightMapper;
    @Resource
    private RoleMapper roleMapper;
    @Resource
    private OperatorMapper operatorMapper;

    @CacheEvict(value={"roleRightCache", "menu"}, allEntries=true)
    public void addObj(RoleRight roleRight) {
        this.roleRightMapper.insertSelective(roleRight);
    }

    @CacheEvict(value={"roleRightCache", "menu"}, allEntries=true)
    public void deleteObjById(String id) {
        this.roleRightMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"roleRightCache", "menu"}, allEntries=true)
    public void modifyObj(RoleRight t) {
        if (StringUtils.isBlank((String)t.getId()) || StringUtils.isBlank((String)t.getKeyId()) || StringUtils.isBlank((String)t.getRoleId()) || StringUtils.isBlank((String)t.getType())) {
            throw new IllegalArgumentException("\u53c2\u6570\u4e0d\u5168\uff0c\u6ca1\u6cd5\u4fee\u6539");
        }
        this.roleRightMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"roleRightCache"}, keyGenerator="redisKeyGenerator")
    public RoleRight queryObjById(String id) {
        return this.roleRightMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"roleRightCache"}, keyGenerator="redisKeyGenerator")
    public List<RoleRight> queryAllObjByExample(RoleRightExample example) {
        return this.roleRightMapper.selectByExample(example);
    }

    @Cacheable(value={"roleRightCache"}, keyGenerator="redisKeyGenerator")
    public PageView<RoleRight> queryObjByPage(RoleRightExample example) {
        PageView<RoleRight> pageView = example.getPageView();
        pageView.setQueryResult(this.roleRightMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @Cacheable(value={"roleRightCache"}, keyGenerator="redisKeyGenerator")
    public List<Role> getRoleByOperatorUrl(String url) {
        OperatorExample operatorExample = new OperatorExample();
        operatorExample.createCriteria().andOperUrlEqualTo(url);
        if (!url.contains(".html")) {
            operatorExample.or().andOperUrlEqualTo(url + ".html");
        }
        List<Operator> operList = this.operatorMapper.selectByExample(operatorExample);
        ArrayList<String> operIdList = new ArrayList<String>();
        for (int i = 0; i < operList.size(); ++i) {
            operIdList.add(operList.get(i).getId().toString());
        }
        if (CollectionUtils.isEmpty(operIdList)) {
            return null;
        }
        RoleRightExample roleRightExample = new RoleRightExample();
        roleRightExample.createCriteria().andKeyIdIn(operIdList).andTypeEqualTo("operator");
        List<RoleRight> roleRightList = this.roleRightMapper.selectByExample(roleRightExample);
        ArrayList<String> roleIdList = new ArrayList<String>();
        for (int i = 0; i < roleRightList.size(); ++i) {
            roleIdList.add(roleRightList.get(i).getRoleId());
        }
        if (CollectionUtils.isEmpty(roleIdList)) {
            return null;
        }
        RoleExample roleExample = new RoleExample();
        roleExample.createCriteria().andIdIn(roleIdList);
        List<Role> roleList = this.roleMapper.selectByExample(roleExample);
        return roleList;
    }

    @Override
    @CacheEvict(value={"roleRightCache", "menu"}, allEntries=true)
    @Transactional
    public void authorized(String roleId, List<RoleRight> rights) {
        RoleRightExample example = new RoleRightExample();
        example.createCriteria().andRoleIdEqualTo(roleId);
        this.roleRightMapper.deleteByExample(example);
        for (RoleRight roleRight : rights) {
            if (StringUtils.isBlank((String)roleRight.getType())) {
                throw new CommonException("\u53c2\u6570[type]\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", new Object[]{"\u53c2\u6570[type]"});
            }
            if (StringUtils.isBlank((String)roleRight.getKeyId())) {
                throw new CommonException("\u53c2\u6570[keyId]\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", new Object[]{"\u53c2\u6570[keyId]"});
            }
            roleRight.setRoleId(roleId);
        }
        for (RoleRight roleRight : rights) {
            this.roleRightMapper.insertSelective(roleRight);
        }
    }

    @Override
    @CacheEvict(value={"roleRightCache", "menu"}, allEntries=true)
    public void deleteByExample(RoleRightExample example) {
        if (CollectionUtils.isEmpty(example.getOredCriteria())) {
            return;
        }
        this.roleRightMapper.deleteByExample(example);
    }
}

