/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.auth.web.controller;

import com.google.code.kaptcha.Producer;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Resource;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Api(value="\u6743\u9650\u7ba1\u7406-\u9a8c\u8bc1\u7801\u7ba1\u7406")
@Controller
@RequestMapping(value={"captcha"})
public class CaptchaController {
    private static Logger logger = LoggerFactory.getLogger(CaptchaController.class);
    @Resource
    private Producer captchaProducer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u83b7\u53d6\u9a8c\u8bc1\u7801", httpMethod="POST")
    @RequestMapping(value={"front/getCaptcha"})
    public void getCaptcha(HttpServletRequest request, HttpServletResponse response) {
        response.setDateHeader("Expires", 0L);
        response.setHeader("Cache-Control", "no-store, no-cache, must-revalidate");
        response.addHeader("Cache-Control", "post-check=0, pre-check=0");
        response.setHeader("Pragma", "no-cache");
        response.setContentType("image/jpeg");
        String capText = this.captchaProducer.createText();
        request.getSession().setAttribute("captcha", (Object)capText);
        BufferedImage bi = this.captchaProducer.createImage(capText);
        ServletOutputStream out = null;
        try {
            out = response.getOutputStream();
            ImageIO.write((RenderedImage)bi, "jpg", (OutputStream)out);
            out.flush();
        }
        catch (IOException e) {
            logger.error("\u751f\u6210\u4e8c\u7ef4\u7801\u5f02\u5e38", (Throwable)e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

