/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.auth.web.controller;

import com.els.base.auth.entity.UserGroup;
import com.els.base.auth.entity.UserGroupExample;
import com.els.base.auth.service.UserGroupService;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u6743\u9650\u7ba1\u7406-\u7528\u6237\u7ec4")
@Controller
@RequestMapping(value={"userGroup"})
public class UserGroupController {
    @Resource
    protected UserGroupService userGroupService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u7528\u6237\u7ec4")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody UserGroup userGroup) {
        this.userGroupService.addObj(userGroup);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u7528\u6237\u7ec4")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody UserGroup userGroup) {
        if (StringUtils.isBlank((String)userGroup.getId())) {
            throw new CommonException("id\u4e3a\u7a7a", "id_is_blank");
        }
        this.userGroupService.modifyObj(userGroup);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u7528\u6237\u7ec4")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(String id) {
        this.userGroupService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="GET", value="\u67e5\u8be2\u7528\u6237\u7ec4")
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<UserGroup>> findByPage(@ApiParam(value="\u6240\u5728\u9875", defaultValue="1") @RequestParam(defaultValue="1") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6") String sSearch) {
        PageView pageView = new PageView(pageNo, pageSize);
        UserGroupExample example = new UserGroupExample();
        example.setPageView((PageView<UserGroup>)pageView);
        if (StringUtils.isNotBlank((String)sSearch)) {
            // empty if block
        }
        PageView pageData = this.userGroupService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="GET", value="\u67e5\u627e\u7528\u6237\u5b50\u5206\u7ec4")
    @RequestMapping(value={"service/findSubUserGroups"})
    @ResponseBody
    public ResponseResult<List<UserGroup>> findSubUserGroups(String userGroupId) {
        if (userGroupId == null) {
            UserGroupExample example = new UserGroupExample();
            example.createCriteria().andParentIdIsNull().andIsEnableEqualTo(Constant.YES_INT);
            return ResponseResult.success((Object)this.userGroupService.queryAllObjByExample((IExample)example));
        }
        return ResponseResult.success(this.userGroupService.querySubChildren(userGroupId));
    }
}

