/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.auth.web.security.impl;

import com.els.base.auth.entity.User;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.project.Project;
import com.els.base.core.entity.project.ProjectExample;
import com.els.base.core.service.project.ProjectService;
import com.els.base.core.utils.Assert;
import com.els.base.utils.http.HttpResponseUtils;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.SavedRequestAwareAuthenticationSuccessHandler;
import org.springframework.stereotype.Component;

@Component(value="customAuthenticationSuccessHandler")
public class CustomAuthenticationSuccessHandler
extends SavedRequestAwareAuthenticationSuccessHandler {
    @Resource
    private ProjectService projectService;

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        User user = (User)((Object)authentication.getPrincipal());
        HttpSession session = request.getSession();
        session.setAttribute("userId", (Object)user.getId());
        if (StringUtils.isBlank((String)user.getProjectCode())) {
            HttpResponseUtils.responseResutlAsJson((HttpServletResponse)response, (Object)ResponseResult.success());
            return;
        }
        ProjectExample projectExample = new ProjectExample();
        projectExample.createCriteria().andProjectCodeEqualTo(user.getProjectCode());
        List projectList = this.projectService.queryAllObjByExample((IExample)projectExample);
        String loginSuccessPage = null;
        Assert.isNotEmpty((Collection)projectList, (String)"\u7528\u6237\u767b\u5f55\u73af\u5883\u7684\u9879\u76ee\u7f16\u7801\u4e0d\u5339\u914d!");
        Project project = (Project)projectList.get(0);
        if (project != null) {
            loginSuccessPage = project.getLoginSuccessPage();
        }
        String protocol = request.getScheme();
        loginSuccessPage = loginSuccessPage.replaceAll("(http|htpps)", protocol);
        HttpResponseUtils.responseResutlAsJson((HttpServletResponse)response, (Object)ResponseResult.success((Object)loginSuccessPage));
    }
}

