/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.auth.web.security.impl;

import com.els.base.auth.exception.CaptchaErrorException;
import com.els.base.auth.exception.CaptchaNotFoundException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.stereotype.Component;

@Component(value="captchaAuthenticaionFilter")
public class CustomCaptchaAuthenticationFilter
extends UsernamePasswordAuthenticationFilter {
    @Value(value="${auth.captcha.is.enable:true}")
    private String isEnable;

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException {
        if (!"true".equals(this.isEnable)) {
            return super.attemptAuthentication(request, response);
        }
        String captcha = this.obtainCaptcha(request);
        Object sessionCaptcha = request.getSession().getAttribute("captcha");
        if (captcha == null || sessionCaptcha == null) {
            throw new CaptchaNotFoundException("\u9a8c\u8bc1\u7801\u5f02\u5e38");
        }
        if (!this.verifyCaptcha(captcha, sessionCaptcha.toString())) {
            throw new CaptchaErrorException("\u9a8c\u8bc1\u7801\u9519\u8bef");
        }
        return super.attemptAuthentication(request, response);
    }

    protected String obtainCaptcha(HttpServletRequest request) {
        return request.getParameter("captcha");
    }

    public boolean verifyCaptcha(String captcha, String sessionCaptcha) {
        return captcha.equalsIgnoreCase(sessionCaptcha);
    }
}

