package com.els.base.auth.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import springfox.documentation.annotations.ApiIgnore;

import java.io.Serializable;
import java.util.Date;

import org.springframework.security.access.ConfigAttribute;

@ApiModel(value="用户角色")
public class Role implements Serializable ,ConfigAttribute{
//	#########以下非自动生成###################
	
	public static final Integer ROLE_LEVEL_SYS = 100;
	public static final Integer ROLE_LEVEL_CUSTOM = 200;
	
	public Role() {
		super();
	}

	public Role(String id, String roleName, Integer roleLevel, String roleCode) {
		super();
		this.id = id;
		this.roleName = roleName;
		this.roleLevel = roleLevel;
		this.roleCode = roleCode;
	}
	
	@ApiModelProperty("是否有授权")
	private boolean authorized;
	
    public boolean getAuthorized() {
		return authorized;
	}

	public void setAuthorized(boolean authorized) {
		this.authorized = authorized;
	}

	@ApiIgnore
	@Override
	public String getAttribute() {
		return this.id;
	}
//	#########非自动生成###################
    @ApiModelProperty("id")
    private String id;

    @ApiModelProperty("角色名称")
    private String roleName;

    @ApiModelProperty("角色级别，系统级别100，用户自定义200")
    private Integer roleLevel;

    @ApiModelProperty("角色编码")
    private String roleCode;

    @ApiModelProperty("角色的创建者Id")
    private String createUserId;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("更新时间")
    private Date updateTime;

    @ApiModelProperty("项目ID")
    private String projectId;

    @ApiModelProperty("公司ID")
    private String companyId;

    private static final long serialVersionUID = 1L;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getRoleName() {
        return roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName == null ? null : roleName.trim();
    }

    public Integer getRoleLevel() {
        return roleLevel;
    }

    public void setRoleLevel(Integer roleLevel) {
        this.roleLevel = roleLevel;
    }

    public String getRoleCode() {
        return roleCode;
    }

    public void setRoleCode(String roleCode) {
        this.roleCode = roleCode == null ? null : roleCode.trim();
    }

    public String getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(String createUserId) {
        this.createUserId = createUserId == null ? null : createUserId.trim();
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId == null ? null : projectId.trim();
    }

    public String getCompanyId() {
        return companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId == null ? null : companyId.trim();
    }
}