package com.els.base.auth.entity;

import java.util.Collection;

import org.springframework.beans.BeanUtils;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

import com.els.base.core.utils.Constant;
import com.fasterxml.jackson.annotation.JsonIgnore;

public class User extends com.els.base.core.entity.user.User implements UserDetails {
	
//	############################################
	
	@JsonIgnore
	private Collection<GrantedAuthority> authorities;
	
	public void setAuthorities(Collection<GrantedAuthority> authorities) {
		this.authorities = authorities;
	}

	@Override
	public Collection<? extends GrantedAuthority> getAuthorities() {
		return this.authorities;
	}

	@Override
	public String getUsername() {
		return this.getLoginName();
	}

	@JsonIgnore
	@Override
	public boolean isAccountNonExpired() {
		if(this.getExpireTime() != null){
			return this.getExpireTime().getTime() < System.currentTimeMillis();
		}
		return true;
	}

	@JsonIgnore
	@Override
	public boolean isAccountNonLocked() {
		return Constant.YES_INT.equals(this.getIsEnable());
	}

	@JsonIgnore
	@Override
	public boolean isCredentialsNonExpired() {
		return Constant.YES_INT.equals(this.getIsEnable());
	}

	@Override
	public boolean isEnabled() {
		return Constant.YES_INT.equals(this.getIsEnable());
	}
//	############################################
	
	private static final long serialVersionUID = 1L;
	
	public static User convertFormBaseUser(com.els.base.core.entity.user.User baseUser){
		
		User authUser = new User();
		BeanUtils.copyProperties(baseUser, authUser);
		return authUser;
		
	}
    
}