package com.els.base.auth.service;

import java.util.List;
import java.util.Map;
import java.util.Set;

import com.els.base.auth.entity.Role;
import com.els.base.auth.entity.RoleExample;
import com.els.base.core.service.BaseService;

/**
 * Created by LiBing on 2014/6/5.
 */
public interface RoleService extends BaseService<Role, RoleExample, String> {

    /**获取登录用户的角色列表(包括自身具有的角色和自身创建的角色)
     * @param isAdmin
     * @param userId
     * @return
     */
    List<Role> queryUserOwnAndCreateRoles(boolean isAdmin, String userId);

    /**根据角色Id查询角色
     * @param roleId
     * @return
     */
    Role queryRoleById(String roleId);

    /**根据用户Id查询用户所具有的角色列表
     * @param userId
     * @return
     */
    List<Role> queryUserOwnRoles(String userId);
    
	Map<String, Set<String>> queryUserOperatorAction(boolean isAdmin, List<String> roleIds);
	
	/**
	 * 查询用户组下的角色
	 * @param organizationId
	 * @return
	 */
	public List<Role> queryAllRoleByUserGroup(String userGroupId);
}
