package com.els.base.auth.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.els.base.auth.dao.UserRoleMapper;
import com.els.base.auth.entity.UserRole;
import com.els.base.auth.entity.UserRoleExample;
import com.els.base.auth.service.UserRoleService;
import com.els.base.core.entity.PageView;
/**
 * Created by LiBing on 2014/6/10.
 */
@Service("userRoleService")
public class UserRoleServiceImpl implements UserRoleService {
    @Autowired
    private UserRoleMapper userRoleMapper;

    @CacheEvict(value={"roleCache", "roleRightCache"}, allEntries=true)
    @Override
    public void addObj(UserRole userRole) {
    	 Date date = new Date();
         userRole.setCreateTime(date);
         userRoleMapper.insertSelective(userRole);
    }
    
    @CacheEvict(value={"roleCache", "roleRightCache"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
    	this.userRoleMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"roleCache", "roleRightCache"}, allEntries=true)
    @Override
    public void modifyObj(UserRole userRole) {
    	if (userRole == null || StringUtils.isBlank(userRole.getId())) {
			throw new IllegalArgumentException("id不能为空");
		}
    	this.userRoleMapper.updateByPrimaryKeySelective(userRole);
    }

    @Cacheable(value="roleCache", keyGenerator="redisKeyGenerator")
    @Override
    public List<UserRole> queryUserRoleList(String userId) {
//        return userRoleMapper.queryListByUserId(userId);
    	UserRoleExample example = new UserRoleExample();
    	example.createCriteria().andUserIdEqualTo(userId);
    	
    	return this.queryAllObjByExample(example);
    }

    @Cacheable(value="roleCache", keyGenerator="redisKeyGenerator")
    @Override
    public List<String> queryUserOwnRoleIds(String userId) {
    	UserRoleExample example = new UserRoleExample();
    	example.createCriteria().andUserIdEqualTo(userId);
    	
    	List<UserRole> list = this.userRoleMapper.selectByExample(example);
    	List<String> ids = new ArrayList<>();
    	for(int i=0; i<list.size(); i++){
    		ids.add(list.get(i).getRoleId());
    	}
    	
    	return ids;
    }

    @CacheEvict(value={"roleCache", "roleRightCache"}, allEntries=true)
    @Override
    public void deleteAllUserRole(String userId) {
//        userRoleMapper.deleteAllUserRole(userId);
    	UserRoleExample example = new UserRoleExample();
    	example.createCriteria().andUserIdEqualTo(userId);
    	
    	this.userRoleMapper.deleteByExample(example);
    }

    @Cacheable(value="roleCache", keyGenerator="redisKeyGenerator")
	@Override
	public UserRole queryObjById(String id) {
		return this.userRoleMapper.selectByPrimaryKey(id);
	}

    @Cacheable(value="roleCache", keyGenerator="redisKeyGenerator")
	@Override
	public List<UserRole> queryAllObjByExample(UserRoleExample example) {
		return this.userRoleMapper.selectByExample(example);
	}

    @Cacheable(value="roleCache", keyGenerator="redisKeyGenerator")
	@Override
	public PageView<UserRole> queryObjByPage(UserRoleExample example) {
		PageView<UserRole> pageView = example.getPageView();
		pageView.setQueryResult(this.userRoleMapper.selectByExampleByPage(example));
		return pageView;
	}

    @Transactional
    @CacheEvict(value={"roleCache", "roleRightCache"}, allEntries=true)
	@Override
	public void resetUserRole(String userId, String[] roleIds) {
		this.deleteAllUserRole(userId);
		for (String roleId : roleIds) {
			UserRole userRole = new UserRole();
			userRole.setUserId(userId);
			userRole.setRoleId(roleId);
			this.addObj(userRole);
		}
	}

    @Cacheable(value="roleCache", keyGenerator="redisKeyGenerator")
	@Override
	public List<String> queryUserIdsForRoleId(String roleId) {
    	UserRoleExample example = new UserRoleExample();
    	example.createCriteria().andRoleIdEqualTo(roleId);
    	
    	List<UserRole> list = this.userRoleMapper.selectByExample(example);
    	List<String> ids = new ArrayList<>();
    	for(int i=0; i<list.size(); i++){
    		ids.add(list.get(i).getUserId());
    	}
    	
    	return ids;
	}
}
