package com.els.base.auth.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;

import com.els.base.auth.entity.Role;
import com.els.base.auth.entity.RoleExample;
import com.els.base.auth.entity.User;
import com.els.base.auth.service.RoleService;
import com.els.base.utils.SpringContextHolder;

/**
 * 权限工具，根据session中的用户信息，查询权限相关的治疗。<p/>
 * 警告:请不要在service中使用。因为是要通过controller层的session获取的，service获取不了。
 */
public class SpringSecurityUtils {
    //获取用户Id
    public static String getLoginUserId() {
        User user = getLoginUser();
        if (user == null ) {
			return null;
		}
        return user.getId();
    }

    //获取登录用户对象
    public static User getLoginUser() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null) {
			return null;
		}
        
        Object obj = authentication.getPrincipal();
        if (obj!=null &&  obj instanceof User) {
            return (User) obj;
        }
        return null;
    }

    //获取登录用户登录账号
    public static String getLoginUserName() {
        String loginName = null;
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        Object obj = authentication.getPrincipal();
        if (obj instanceof User) {
            User user = (User) obj;
            if (user != null) {
                loginName = user.getLoginName();
            }
        }
        return loginName;
    }

    //获取登录用户的角色名称列表
    @SuppressWarnings("unchecked")
	public static List<String> getLoginUserRoleIdList() {
        List<String> roleIds = new ArrayList<>();
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        Collection<GrantedAuthority> authorities = (Collection<GrantedAuthority>) authentication.getAuthorities();
        for (GrantedAuthority authority : authorities) {
            roleIds.add(authority.getAuthority());
        }
        return roleIds;
    }
    
    @SuppressWarnings("unchecked")
	public static List<Role> getLoginUserRoleList() {
        List<String> roleIds = new ArrayList<>();
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        Collection<GrantedAuthority> authorities = (Collection<GrantedAuthority>) authentication.getAuthorities();
        for (GrantedAuthority authority : authorities) {
            roleIds.add(authority.getAuthority());
        }
        if (CollectionUtils.isEmpty(roleIds)) {
			return null;
		}
        
        RoleExample roleExample = new RoleExample();
        roleExample.createCriteria().andIdIn(roleIds);
        return SpringContextHolder.getOneBean(RoleService.class).queryAllObjByExample(roleExample);
    }

    //判断登录用户是否是管理员身份(是管理员身份就可以看该栏目的所有数据，否则只能看到自己的数据)
    public static  boolean isManagerLoginUser(){
        if("admin".equals(getLoginUserName())){
            return true;
        }
//        List<String> roles = getLoginUserRoleIdList();
//        if(roles.contains("系统管理员")){
//            return true;
//        }
        return false;
    }

}
