package com.els.base.auth.web.controller;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.els.base.auth.entity.Menu;
import com.els.base.auth.service.MenuService;
import com.els.base.auth.service.RoleRightService;
import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.core.entity.ResponseResult;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

@Api("权限管理-菜单管理")
@Controller
@RequestMapping("menu")
public class MenuController {
	@Autowired
	private MenuService menuService;
	
	@Resource
	private RoleRightService roleRightService;

	@ApiOperation(value = "添加菜单", httpMethod = "POST")
	@RequestMapping("service/addMenu")
	@ResponseBody
	public ResponseResult<String> addMenu(@RequestBody Menu menu) {
		menu.setId(null);
		this.menuService.addObj(menu);
		return ResponseResult.success();
	}

	@ApiOperation(value = "根据id删除菜单", httpMethod = "GET")
	@RequestMapping("service/deleteMenu")
	@ResponseBody
	public ResponseResult<String> deleteMenu(@RequestParam(required=true) String menuId) {
		menuService.deleteObjById(menuId);

		return ResponseResult.success();
	}

	@ApiOperation(value = "修改菜单", httpMethod = "POST")
	@RequestMapping("service/modifyMenu")
	@ResponseBody
	public ResponseResult<String> modifyMenu(@RequestBody Menu menu) {
		this.menuService.modifyObj(menu);

		return ResponseResult.success();
	}
	
	@ApiOperation(value = "查询所有的菜单", httpMethod = "GET")
	@RequestMapping(value = "service/queryAllMenuTree")
	@ResponseBody
	public ResponseResult<List<Menu>> queryAllMenuTree() {
		return ResponseResult.success(this.menuService.queryAuthedMenuForRoleIds(SpringSecurityUtils.getLoginUserRoleIdList()));
	}

	@ApiOperation(value = "查询菜单树(带上权限标记)", httpMethod = "GET")
	@RequestMapping(value = "service/queryMenuTreeData")
	@ResponseBody
	public ResponseResult<List<Menu>> queryMenuTreeData(@RequestParam(required=true) String roleId) {
		
		List<String> roleIds = new ArrayList<>();
		roleIds.add(roleId);
		List<Menu> list = this.menuService.queryAllMenuWithAuthRoleIds(SpringSecurityUtils.getLoginUserRoleIdList(), roleIds);

		return ResponseResult.success(list);
	}

	@ApiOperation(value = "查询当前用户的菜单树",httpMethod="GET")
	@RequestMapping(value = "service/queryMenuForCurrentUser")
	@ResponseBody
	public ResponseResult<List<Menu>> queryMenuForCurrentUser() {
		List<Menu> list = null;
		
		List<String> roleId = SpringSecurityUtils.getLoginUserRoleIdList();
		list = this.menuService.queryAuthedMenuForRoleIds(roleId);

		
		return ResponseResult.success(list);
	}
	

}
