package com.els.base.auth.web.controller;

import javax.annotation.Resource;

import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.els.base.auth.entity.Operator;
import com.els.base.auth.entity.OperatorExample;
import com.els.base.auth.service.OperatorService;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

/**
 * Created by LiBing on 2014-07-17 14:16
 */
@Api("权限管理-接口请求url")
@Controller
@RequestMapping("operator")
public class OperatorController {

    @Resource
    private OperatorService operatorService;

    @ApiOperation(value = "添加请求url", httpMethod = "POST")
    @RequestMapping("service/addOperator")
    @ResponseBody
    public ResponseResult<String> addOperator(@RequestBody Operator operator) {
    	Assert.isNotBlank(operator.getMenuId(), "数据还没有关联菜单");
    	Assert.isNotBlank(operator.getOperCode(), "code不能为空");
    	
        operator.setId(null);
        this.operatorService.addObj(operator);

        return ResponseResult.success();
    }

    @ApiOperation(value = "删除请求url", httpMethod = "GET")
    @RequestMapping("service/deleteOperator")
    @ResponseBody
    public ResponseResult<String> deleteOperator(@RequestParam(required = true) String id) {
        this.operatorService.deleteObjById(id);

        return ResponseResult.success();
    }

    @ApiOperation(value = "修改请求url", httpMethod = "POST")
    @RequestMapping("service/modifyOperator")
    @ResponseBody
    public ResponseResult<String> modifyOperator(@RequestBody Operator operator) {
        if (StringUtils.isBlank(operator.getId())) {
            throw new CommonException("id为空", "id_is_blank");
        }
        this.operatorService.modifyObj(operator);

        return ResponseResult.success();
    }

    @ApiOperation(value = "查询菜单下的请求url", httpMethod = "GET")
    @RequestMapping("service/queryMenuOperatorList")
    @ResponseBody
    public ResponseResult<PageView<Operator>> queryMenuOperatorList(
            @ApiParam(value = "所在页", defaultValue = "1") @RequestParam(defaultValue = "1") int pageNo,
            @ApiParam(value = "每页数量", defaultValue = "10") @RequestParam(defaultValue = "10") int pageSize,
            @ApiParam(value = "菜单id", defaultValue = "10")@RequestParam(required = true) String menuId) {
    	
    	OperatorExample operatorExample = new OperatorExample();
    	operatorExample.setPageView(new PageView<Operator>(pageNo, pageSize));
    	
    	operatorExample.createCriteria().andMenuIdEqualTo(menuId);
        return ResponseResult.success(this.operatorService.queryObjByPage(operatorExample));
    }

    /*@ApiOperation(value = "查询角色在菜单下,获取授权的请求url", httpMethod = "GET")
    @RequestMapping("service/queryRoleOperatorList")
    @ResponseBody
    public ResponseResult<PageView<Operator>> queryRoleOperatorList(
            @ApiParam(value = "菜单id") String menuId,
            @ApiParam(value = "所在页", defaultValue = "1") @RequestParam(defaultValue = "1") int pageNo,
            @ApiParam(value = "每页数量", defaultValue = "10") @RequestParam(defaultValue = "10") int pageSize) {

    	OperatorExample operatorExample = new OperatorExample();
    	operatorExample.setPageView(new PageView<Operator>(pageNo, pageSize));
    	
    	operatorExample.createCriteria().andMenuIdEqualTo(menuId);
        return ResponseResult.success(this.operatorService.queryObjByPage(operatorExample));
    }*/

}
