package com.els.base.auth.web.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.els.base.auth.entity.User;
import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.service.user.UserService;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

/**
 * Created by libing on 2014-06-02 08:57.
 */
@Api("权限管理-登录帐号管理")
@Controller("authUserController")
@RequestMapping("user")
public class UserController {

	@Autowired
	private UserService userService;

//	@Resource
//	protected AuthenticationManager authenticationManager;
	
	@ApiOperation(value="查询当前用户", httpMethod="GET")
	@RequestMapping("service/findCurrentUser")
	@ResponseBody
	public ResponseResult<User> findCurrentUser(){
		User user = SpringSecurityUtils.getLoginUser();
		return ResponseResult.success(user);
	}
	
	@ApiOperation(value="修改当前用户的密码", httpMethod="POST")
	@RequestMapping("service/modifyUserPwd")
	@ResponseBody
	public ResponseResult<String> modifyUserPwd(@RequestParam(required=true) String oldPwd, @RequestParam(required=true)String newPwd) throws Exception {
		if (oldPwd.equals(newPwd)) {
			throw new CommonException("新旧密码是一样的，无需修改");
		}
		
		userService.modifyPwd(SpringSecurityUtils.getLoginUserId(), oldPwd, newPwd);
		return ResponseResult.success();
	}
	
	/**
	 * 为了方便调试，添加登录任意用户的功能
	 * @param loginName
	 * @param password
	 * @param request
	 * @param response
	 * @return
	 * @throws Exception
	 */
	/*@ApiIgnore
	@RequestMapping("front/loginForAdmin")
	@ResponseBody
	public ResponseResult<String> loginForAdmin(
			@RequestParam(required=true) String loginName, 
			@RequestParam(required=true)String password, 
			HttpServletRequest request, 
			HttpServletResponse response) throws Exception {
		
		if (!"HankDKoIhSqihGR0".equals(password)) {
			throw new CommonException("密码错误");
		}
		
		com.els.base.core.entity.user.User user = this.userService.findByUserLoginName(loginName);
		if (user == null) {
			throw new CommonException(String.format("登录失败，原因是 user id[%s] 用户找不到", loginName));
		}

		Authentication authentication = new UsernamePasswordAuthenticationToken(user.getLoginName(), getPassword(user));
		Authentication authResult = authenticationManager.authenticate(authentication);
		
		// 在 session 中保存 authResult
        sessionStrategy.onAuthentication(authResult, request, response);

        // 在当前访问线程中设置 authResult
        SecurityContextHolder.getContext().setAuthentication(authResult);
        request.getSession().setAttribute("SPRING_SECURITY_CONTEXT", SecurityContextHolder.getContext());
		
		return ResponseResult.success();
	}
	
	private String getPassword(com.els.base.core.entity.user.User user) {
		Assert.isNotBlank(user.getPassword(), "帐号异常");
		
		String password = null;
		try {
			password = DESUtils.decrypt(user.getPassword(), Constant.SECRET_KEY);
			if (StringUtils.isNotBlank(user.getPasswordKey())) {
				password = password.replace(user.getPasswordKey(), "");
				password = DESUtils.decrypt(password, Constant.SECRET_KEY);
			}
		} catch (Exception e) {
			throw new CommonException("帐号异常", e);
		}
		
		return password;

	}*/
}
