package com.els.base.auth.web.controller;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import com.els.base.auth.entity.UserRole;
import com.els.base.auth.entity.UserRoleExample;
import com.els.base.auth.service.UserRoleService;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

/**
 * Created by libing on 2014-06-02 08:57.
 */
@Api("权限管理-用户角色关联管理")
@Controller
@RequestMapping("userRole")
public class UserRoleController {
    @Autowired
    private UserRoleService rightService;

    @ApiOperation(value = "给用户增加角色", httpMethod = "POST")
    @RequestMapping("service/addUserRoleRight")
    @ResponseBody
    public ResponseResult<String> addUserRoleRight(String roleId, String userId) {
        UserRoleExample example = new UserRoleExample();
        example.createCriteria().andUserIdEqualTo(userId).andRoleIdEqualTo(roleId);

        if (CollectionUtils.isNotEmpty(this.rightService.queryAllObjByExample(example))) {
            return ResponseResult.success();
        }

        UserRole userRole = new UserRole();
        userRole.setRoleId(roleId);
        userRole.setUserId(userId);
        rightService.addObj(userRole);

        return ResponseResult.success();
    }

    @ApiOperation(value = "给用户删除角色", httpMethod = "POST")
    @RequestMapping("service/deleteUserRoleRight")
    @ResponseBody
    public ResponseResult<String> deleteUserRight(String rightId) {
        rightService.deleteObjById(rightId);

        return ResponseResult.success();
    }

    @ApiOperation(value = "修改用户的角色", httpMethod = "POST")
    @RequestMapping("/modifyUserRoleRight")
    @ResponseBody
    public ResponseResult<String> modifyUserRight(String rightId, String roleId, String userId) {
        UserRole userRole = new UserRole();
        userRole.setId(rightId);
        userRole.setRoleId(roleId);
        userRole.setUserId(userId);
        rightService.modifyObj(userRole);

        return ResponseResult.success();
    }

    @ApiOperation(value = "给用户添加多个角色", httpMethod = "POST")
    @RequestMapping("service/addUserRoleList")
    @ResponseBody
    public ResponseResult<String> addUserRoleList(String roleIds, String userId) {
        if (StringUtils.isBlank(roleIds)) {
            throw new CommonException("角色数据不能为空", "base_canot_be_null","角色数据");
        }

        String[] userRoleIds = roleIds.split(",");
        this.rightService.resetUserRole(userId, userRoleIds);
        return ResponseResult.success();
    }
}
