package com.els.base.auth.web.security.impl;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.stereotype.Component;

import com.els.base.auth.exception.CaptchaErrorException;
import com.els.base.auth.exception.CaptchaNotFoundException;
import com.els.base.auth.utils.AuthConstant;

@Component("captchaAuthenticaionFilter")
public class CustomCaptchaAuthenticationFilter extends UsernamePasswordAuthenticationFilter {
	
	@Value("${auth.captcha.is.enable:true}")
	private String isEnable;

//	public static final String SPRING_SECURITY_FORM_CAPTCHA_KEY = "captcha";
	// private String captchaParameter = SPRING_SECURITY_FORM_CAPTCHA_KEY;

	@Override
	public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response)
			throws AuthenticationException {
		
		if (!"true".equals(this.isEnable)) {
			return super.attemptAuthentication(request, response);
		}

		String captcha = obtainCaptcha(request);
		Object sessionCaptcha = request.getSession().getAttribute(AuthConstant.CAPTCHA_KEY);

		if (captcha == null || sessionCaptcha == null) {
			throw new CaptchaNotFoundException("验证码异常");
		}

		if (!verifyCaptcha(captcha, sessionCaptcha.toString())) {
			throw new CaptchaErrorException("验证码错误");
		}

		return super.attemptAuthentication(request, response);
	}

	protected String obtainCaptcha(HttpServletRequest request) {
		return request.getParameter(AuthConstant.CAPTCHA_KEY);
	}

	public boolean verifyCaptcha(String captcha, String sessionCaptcha) {
		if (captcha.equalsIgnoreCase(sessionCaptcha)) {
			return true;
		}
		return false;
	}

}
