package com.els.base.auth.web.security.impl;

import java.io.IOException;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.web.filter.OncePerRequestFilter;

import com.els.base.utils.i18n.I18nUtils;

/**
 * 权限校验中，实现国际化的配置
 * @author hzy
 *
 */
public class LocaleChangeAndSaveFilter extends OncePerRequestFilter{


	@Override
	protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain)
			throws ServletException, IOException {
		
		I18nUtils.setLocalByRequest(request, response);
		filterChain.doFilter(request, response);
		
	}

}
