package com.els.base.auth.entity;

import java.io.Serializable;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(value="用户组")
public class UserGroup implements Serializable {
	
//	########非自动生成,上级用户组##############
	
	private UserGroup parent;
	
	public UserGroup getParent() {
		return parent;
	}
	
	public void setParent(UserGroup parent) {
		this.parent = parent;
	}
	
    @Override
	public boolean equals(Object obj) {
    	if (super.equals(obj)) {
			return true;
		}
    	
    	if (!(obj instanceof UserGroup)) {
			return false;
		}
    	
    	UserGroup tmp = (UserGroup) obj;
		
		if (this.getId() == null || tmp.getId() == null) {
			return false;
		}
		
		return this.getId().equals(tmp.getId());
	}

	//	###########################
	
    @ApiModelProperty("主键")
    private String id;

    @ApiModelProperty("上级用户组id")
    private String parentId;

    private String projectId;

    @ApiModelProperty("用户组名称")
    private String name;

    @ApiModelProperty("用户组代码，唯一码")
    private String code;

    @ApiModelProperty("是否可用，1可用，0禁用")
    private Integer isEnable;

    private static final long serialVersionUID = 1L;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getParentId() {
        return parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId == null ? null : parentId.trim();
    }

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId == null ? null : projectId.trim();
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name == null ? null : name.trim();
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code == null ? null : code.trim();
    }

    public Integer getIsEnable() {
        return isEnable;
    }

    public void setIsEnable(Integer isEnable) {
        this.isEnable = isEnable;
    }
}