package com.els.base.auth.service;

import java.util.List;

import com.els.base.auth.entity.Menu;
import com.els.base.auth.entity.MenuExample;
import com.els.base.core.service.BaseService;

public interface MenuService extends BaseService<Menu, MenuExample, String> {

	/**
	 * 为管理员，查询所有的菜单，带上菜单的授权信息
	 * @return
	 */
//    List<Menu> queryAllMenuWithAuthForAdmin();
    
    /**
     * 查询所有的菜单
     * @return
     */
//    List<Menu> queryAllMenu();
    
    /**
     * 根据父节点查询对应的子节点
     * @param parentMenuId
     * @return
     */
//    List<Menu> getChildrendMenu(String parentMenuId);
    
//    Menu queryMenuByURL(String url);
    
    /**
     * 根据角色id，查询所有的菜单，并带上菜单的授权信息
     * @param roleIds
     * @return
     */
	List<Menu> queryAllMenuWithAuthRoleIds(List<String> loginUserRoleIdList, List<String> roleIds);

	/**
     * 根据角色id,查询已经授权的菜单
     * @param roleIds
     * @return
     */
	List<Menu> queryAuthedMenuForRoleIds(List<String> roleId);
}
