package com.els.base.auth.web.controller;

import java.awt.image.BufferedImage;
import java.io.IOException;

import javax.annotation.Resource;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

import com.els.base.auth.utils.AuthConstant;
import com.google.code.kaptcha.Producer;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

@Api("权限管理-验证码管理")
@Controller
@RequestMapping("captcha")
public class CaptchaController {
	
	private static Logger logger = LoggerFactory.getLogger(CaptchaController.class);

	@Resource
	private Producer captchaProducer;

	@ApiOperation(value = "获取验证码", httpMethod = "POST")
	@RequestMapping("front/getCaptcha")
	public void getCaptcha(HttpServletRequest request, HttpServletResponse response) {
		// Set to expire far in the past.
		response.setDateHeader("Expires", 0);
		// Set standard HTTP/1.1 no-cache headers.
		response.setHeader("Cache-Control", "no-store, no-cache, must-revalidate");
		// Set IE extended HTTP/1.1 no-cache headers (use addHeader).
		response.addHeader("Cache-Control", "post-check=0, pre-check=0");
		// Set standard HTTP/1.0 no-cache header.
		response.setHeader("Pragma", "no-cache");

		// return a jpeg
		response.setContentType("image/jpeg");

		// create the text for the image
		String capText = captchaProducer.createText();

		// store the text in the session
		request.getSession().setAttribute(AuthConstant.CAPTCHA_KEY, capText);

		// create the image with the text
		BufferedImage bi = captchaProducer.createImage(capText);
		ServletOutputStream out = null;
		try {
			out = response.getOutputStream();
			ImageIO.write(bi, "jpg", out);
			out.flush();
		} catch (IOException e) {
			logger.error("生成二维码异常", e);
			
		} finally {
			if (out != null) {
				try {
					out.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
		}
	}

	/*
	 * @ApiOperation(value = "获取验证码", httpMethod = "POST")
	 * 
	 * @RequestMapping("front/getCaptcha") public void
	 * getCaptcha(HttpServletRequest request, HttpServletResponse response) {
	 * response.setContentType("image/jpeg"); response.setHeader("Pragma",
	 * "no-cache"); response.setHeader("Cache-Control", "no-cache");
	 * response.setDateHeader("Expires", 0);
	 * 
	 * CreateImageCaptcha captcha = new CreateImageCaptcha(100,34,5,10);
	 * 
	 * request.getSession().setAttribute("captcha", captcha.getCode());
	 * 
	 * try { captcha.write(response.getOutputStream()); } catch (IOException e)
	 * { e.printStackTrace(); } }
	 */

}
