package com.els.base.auth.service;

import java.util.List;

import com.els.base.auth.entity.UserGroup;
import com.els.base.auth.entity.UserGroupExample;
import com.els.base.core.entity.user.User;
import com.els.base.core.service.BaseService;

public interface UserGroupService extends BaseService<UserGroup, UserGroupExample, String> {
	
	/**
	 * 把帐号添加到组织中
	 * @param userId
	 * @param userGroupId
	 */
	public void addUserIntoUserGroup(String userId, String userGroupId);
	
	/**
	 * 查找帐号所属的组织，包括是当前组织，以及组织的父级链
	 * @param userId
	 * @return
	 */
	public UserGroup queryUserGroupsByUserId(String userId);
	
	/**
	 * 查找当前组织，以及组织的父级链
	 * @param userGroupId
	 * @return
	 */
	public UserGroup queryParents(String userGroupId);
	
	/**
	 * 查询下一级的子组织
	 * @param userGroupId
	 * @return
	 */
	public List<UserGroup> querySubChildren(String userGroupId);
	
	/**
	 * 查询所有的下级组织
	 * @param orgnization
	 * @return
	 */
	public List<UserGroup> queryAllChildren(String userGroupId);
	
	/**
	 * 查找组织下的所有用户
	 * @param userGroupId
	 * @return
	 */
	public List<User> queryUserByUserGroupId(String userGroupId);
}