package com.els.base.auth.web.security;

import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Component;

import com.els.base.core.utils.Constant;
import com.els.base.utils.encryption.DESUtils;

/**
 * Created by LiBing on 2014/6/5.
 * Update by wzy on 2017/5/2
 * 系统用户密码加密
 */
@Component("customPasswordEncoder")
public class CustomPasswordEncoder implements PasswordEncoder {

	@Override
	public String encode(CharSequence rawPassword) {
		try {
			return DESUtils.encrypt(rawPassword.toString(), Constant.SECRET_KEY);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
	}

	@Override
	public boolean matches(CharSequence rawPassword, String encodedPassword) {
		try {
            String encOrig = DESUtils.encrypt(rawPassword.toString(), Constant.SECRET_KEY);
            return encodedPassword.equals(encOrig);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return false;
	}
}
