package com.els.base.auth.web.security.impl;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.web.access.AccessDeniedHandlerImpl;
import org.springframework.stereotype.Component;

import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.ResponseCode;
import com.els.base.utils.http.HttpResponseUtils;

/**
 * 用户没有权限时的操作
 * @author hzy
 *
 */
@Component("accessDeniedHandler")
public class CustomAccessDeniedHandler extends AccessDeniedHandlerImpl {

	@Override
	public void handle(HttpServletRequest request, HttpServletResponse response, AccessDeniedException accessDeniedException)
			throws IOException, ServletException {
		
		// 如果是ajax请求
//		if (HttpRequestUtils.isAjaxRequest(request)) {

			ResponseResult<String> result = ResponseResult.fail(ResponseCode.Account_Permission_denied);
			HttpResponseUtils.responseResutlAsJson(response, result);
			return;
			
//		} else {
//			super.handle(request, response, accessDeniedException);
//		}
	}

}
