package com.els.base.auth.web.security.impl;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;

import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.ResponseCode;
import com.els.base.utils.http.HttpResponseUtils;

/**
 * 默认的登录入口
 * 
 * @author hzy
 *
 */
public class CustomAuthenticationEntryPoint extends LoginUrlAuthenticationEntryPoint {

	public CustomAuthenticationEntryPoint(String loginFormUrl) {
		super(loginFormUrl);
	}

	@Override
	public void commence(HttpServletRequest request, HttpServletResponse response,
			AuthenticationException authException) throws IOException, ServletException {

//		if (HttpRequestUtils.isAjaxRequest(request)) {

			ResponseResult<String> result = ResponseResult.fail(ResponseCode.Account_No_Login);
			HttpResponseUtils.responseResutlAsJson(response, result);
			return;
//		}
//
//		super.commence(request, response, authException);
	}

}
