package com.els.base.auth.web.security.impl;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.security.authentication.AccountExpiredException;
import org.springframework.security.authentication.AccountStatusException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.CredentialsExpiredException;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.authentication.LockedException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.web.authentication.ExceptionMappingAuthenticationFailureHandler;
import org.springframework.security.web.authentication.session.SessionAuthenticationException;
import org.springframework.stereotype.Component;

import com.els.base.auth.exception.CaptchaErrorException;
import com.els.base.auth.exception.CaptchaNotFoundException;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.ResponseCode;
import com.els.base.utils.http.HttpResponseUtils;

/**
 * 用户登录失败的处理器,添加ajax请求的处理
 * @author hzy
 *
 */
@Component("customAuthenticationFailureHandler")
public class CustomAuthenticationFailureHandler extends ExceptionMappingAuthenticationFailureHandler {

	@Override
	public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response,
			AuthenticationException exception) throws IOException, ServletException {

//		if (HttpRequestUtils.isAjaxRequest(request)) {
			ResponseResult<String> result = this.getErrMsg(exception);
			
			HttpResponseUtils.responseResutlAsJson(response, result);
			return;
//		}
//
//		super.onAuthenticationFailure(request, response, exception);
	}

	/**
	 * 获取登录失败的原因
	 * @param exception
	 * @return
	 */
	private ResponseResult<String> getErrMsg(AuthenticationException exception) {
		if (exception instanceof AccountExpiredException) {
			return ResponseResult.fail(ResponseCode.Account_Expired);
			
		}else if (exception instanceof DisabledException) {
			return ResponseResult.fail(ResponseCode.Account_Disabled);
			
		}else if (exception instanceof LockedException) {
			return ResponseResult.fail(ResponseCode.Account_Locked);
			
		}else if (exception instanceof CredentialsExpiredException) {
			return ResponseResult.fail(ResponseCode.Accouont_Password_Expired);
			
		}else if (exception instanceof AccountStatusException) {
			return ResponseResult.fail(ResponseCode.Account_Sessioin_Expired);
			
		}else if (exception instanceof BadCredentialsException) {
			return ResponseResult.fail(ResponseCode.Account_Password_Worng);
			
		}else if (exception instanceof UsernameNotFoundException) {
			return ResponseResult.fail(ResponseCode.Account_Username_Not_Found);
			
		}else if (exception instanceof SessionAuthenticationException) {
			return ResponseResult.fail(ResponseCode.Account_Sessioin_Expired);
		}else if(exception instanceof CaptchaNotFoundException){
			return ResponseResult.fail(ResponseCode.Account_Captcha_Not_Found);
		}else if(exception instanceof CaptchaErrorException){
			return ResponseResult.fail(ResponseCode.Account_Captcha_Worng);
		}else {
			
			ResponseResult<String> result = new ResponseResult<>();
			result.setCode("403");
			result.setMsg("登录失败");
			return result;
		}
	}

}
