package com.els.base.auth.web.security.impl;

import java.io.IOException;
import java.util.List;

import javax.annotation.Resource;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.logout.SimpleUrlLogoutSuccessHandler;

import com.els.base.auth.entity.User;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.project.Project;
import com.els.base.core.entity.project.ProjectExample;
import com.els.base.core.service.project.ProjectService;
import com.els.base.utils.http.HttpResponseUtils;

public class CustomLogoutSuccessHandler extends SimpleUrlLogoutSuccessHandler {

    @Resource
    private ProjectService projectService;

    @Override
    public void onLogoutSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication)
            throws IOException, ServletException {
    	if (authentication == null) {
    		HttpResponseUtils.responseResutlAsJson(response, ResponseResult.success(null));
    		return;
		}
    	
        User user = (User) authentication.getPrincipal();
        if (user == null) {
        	HttpResponseUtils.responseResutlAsJson(response, ResponseResult.success(null));
        	return;
		}
        
        ProjectExample projectExample = new ProjectExample();
        projectExample.createCriteria().andProjectCodeEqualTo(user.getProjectCode());
        List<Project> projectList = projectService.queryAllObjByExample(projectExample);
        String logoutPage = null;
        if (CollectionUtils.isNotEmpty(projectList)) {
            Project project = projectList.get(0);
            if (project != null) {
				logoutPage = project.getLogoutSuccessPage();
			}
        }

        // if (HttpRequestUtils.isAjaxRequest(request)) {
        HttpResponseUtils.responseResutlAsJson(response, ResponseResult.success(logoutPage));
        // if (HttpRequestUtils.isAjaxRequest(request)) {
        // }

        // super.onLogoutSuccess(request, response, authentication);

    }

}
