package com.els.base.auth.web.security.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;

import com.els.base.auth.entity.Role;
import com.els.base.auth.entity.UserGroup;
import com.els.base.auth.entity.UserRole;
import com.els.base.auth.service.RoleService;
import com.els.base.auth.service.UserGroupService;
import com.els.base.auth.service.UserRoleService;
import com.els.base.auth.utils.AuthConstant;
import com.els.base.core.entity.user.User;
import com.els.base.core.entity.user.UserExample;
import com.els.base.core.service.user.UserService;
import com.els.base.core.utils.Constant;

/**
 * 给用户增加对应权限
 * @author hzy
 *
 */
@Service("customUserDetailsService")
public class CustomUserDetailsServiceImpl implements UserDetailsService {

	@Resource
    private UserService userService;

    @Autowired
    private UserRoleService userRoleService;
    
    @Resource
    private UserGroupService userGroupService;
    
    private RoleService roleService;
    
	@Override
	public UserDetails loadUserByUsername(String loginNameInput) throws UsernameNotFoundException {
		//取得登录用户
    	UserExample userExample = new UserExample();
    	
    	if(loginNameInput.indexOf("@") > 0){
    		userExample.createCriteria()
    			.andIsEnableEqualTo(Constant.YES_INT)
    			.andEmailEqualTo(loginNameInput.toLowerCase());
    		userExample.or()
    			.andIsEnableEqualTo(Constant.YES_INT)
    			.andEmailEqualTo(loginNameInput.toUpperCase());
    		
    	}else if(loginNameInput.matches("1\\d{10}") || loginNameInput.matches("\\+861\\d{10}") || loginNameInput.matches("861\\d{10}")){
    		userExample.createCriteria()
				.andIsEnableEqualTo(Constant.YES_INT)
				.andMobilePhoneEqualTo(loginNameInput);
    		
    	}else {
    		userExample.createCriteria()
				.andIsEnableEqualTo(Constant.YES_INT)
				.andLoginNameEqualTo(loginNameInput.toLowerCase());
			
			userExample.or()
				.andIsEnableEqualTo(Constant.YES_INT)
				.andLoginNameEqualTo(loginNameInput.toUpperCase());
		}
    	
    	List<User> list = this.userService.queryAllObjByExample(userExample);
    	//账号被禁用时不可登陆
        if (list==null ||  list.size()==0) {
            throw new UsernameNotFoundException( "The user name "  + loginNameInput + " can not be found!" );
        }

        User user = list.get(0);
        if (user == null) {
        	throw new UsernameNotFoundException( "The user name "  + loginNameInput + " can not be found!" );
		}
        
        Collection<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>();
        
        Set<String> roleIdList = new HashSet<>();
        
        //查询用户所在的组织
        UserGroup userGroup = this.userGroupService.queryUserGroupsByUserId(user.getId());
        if (userGroup != null) {
        	List<Role> roleList = this.roleService.queryAllRoleByUserGroup(userGroup.getId());
        	for(int i=0; CollectionUtils.isNotEmpty(roleList) && i<roleList.size(); i++){
        		roleIdList.add(roleList.get(i).getId());
        	}
		}
        
        //取得用户相关的权限信息
        List<UserRole> userRoleList = userRoleService.queryUserRoleList(user.getId());
        for (int i=0; CollectionUtils.isNotEmpty(userRoleList) && i<userRoleList.size(); i++) {
        	roleIdList.add(userRoleList.get(i).getRoleId());
		}
        
        for (String roleId : roleIdList) {
            GrantedAuthority authority = new SimpleGrantedAuthority(roleId.toString());
            authorities.add(authority);
        }
        authorities.add(new SimpleGrantedAuthority(AuthConstant.DEFAULT_ROLE.getId()));
        
        com.els.base.auth.entity.User authUser = com.els.base.auth.entity.User.convertFormBaseUser(user);
        authUser.setAuthorities(authorities);

        return authUser;
	}
	
}
