/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.auth.config;

import com.els.base.auth.web.security.impl.CustomAccessDecisionManagerImpl;
import com.els.base.auth.web.security.impl.CustomAccessDeniedHandler;
import com.els.base.auth.web.security.impl.CustomAuthenticationEntryPoint;
import com.els.base.auth.web.security.impl.CustomCaptchaAuthenticationFilter;
import com.els.base.auth.web.security.impl.CustomDaoAuthenticationProvider;
import com.els.base.auth.web.security.impl.CustomFilterInvocationSecurityMetadataSource;
import com.els.base.auth.web.security.impl.CustomInvalidSessionStrategy;
import com.els.base.auth.web.security.impl.CustomLogoutSuccessHandler;
import com.els.base.auth.web.security.impl.LocaleChangeAndSaveFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.Filter;
import org.springframework.context.annotation.Bean;
import org.springframework.security.access.AccessDecisionManager;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.ProviderManager;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.access.ExceptionTranslationFilter;
import org.springframework.security.web.access.intercept.FilterInvocationSecurityMetadataSource;
import org.springframework.security.web.access.intercept.FilterSecurityInterceptor;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.security.web.session.ConcurrentSessionFilter;
import org.springframework.security.web.session.InvalidSessionStrategy;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

@EnableWebSecurity
public class SecurityConfiguration
extends WebSecurityConfigurerAdapter {
    @Resource(name="customPasswordEncoder")
    PasswordEncoder passwordEncoder;
    @Resource(name="customUserDetailsService")
    UserDetailsService userDetailsService;
    @Resource(name="customAuthenticationFailureHandler")
    AuthenticationFailureHandler failureHandler;
    @Resource(name="customAuthenticationSuccessHandler")
    protected AuthenticationSuccessHandler successHandler;
    @Resource(name="accessDeniedHandler")
    protected CustomAccessDeniedHandler accessDeniedHandler;
    @Resource(name="customAccessDecisionManager")
    protected CustomAccessDecisionManagerImpl customAccessDecisionManager;
    @Resource(name="customFilterInvocationSecurityMetadataSource")
    protected CustomFilterInvocationSecurityMetadataSource customFilterInvocationSecurityMetadataSource;
    private static List<RequestMatcher> anonymousMatchers = new ArrayList<RequestMatcher>();

    private static void configAnonymousMatchers(String ... antPatterns) {
        for (String pattern : antPatterns) {
            anonymousMatchers.add((RequestMatcher)new AntPathRequestMatcher(pattern));
        }
    }

    public static List<RequestMatcher> getAnonymousMatchers() {
        return anonymousMatchers;
    }

    public void configure(WebSecurity web) throws Exception {
        ((WebSecurity.IgnoredRequestConfigurer)web.ignoring().antMatchers(new String[]{"/resources/**", "/swagger/**", "/mobileview/**", "/login.html*"})).antMatchers(new String[]{"/captcha/**", "/v2/api-docs"});
    }

    protected void configure(HttpSecurity http) throws Exception {
        http.addFilterBefore(this.getLocaleChangeAndSaveFilter(), ConcurrentSessionFilter.class).addFilterBefore(this.getCaptchaAuthenticaionFilter(), UsernamePasswordAuthenticationFilter.class).addFilterBefore(this.getExceptionTranslationFilter(), FilterSecurityInterceptor.class).addFilterBefore(this.getCustomFilterSecurityInterceptor(), FilterSecurityInterceptor.class);
        http.sessionManagement().sessionFixation().migrateSession();
        http.sessionManagement().invalidSessionStrategy(this.getInvalidSessionStrategy());
        http.sessionManagement().sessionAuthenticationErrorUrl("/login.html");
        http.sessionManagement().maximumSessions(1).maxSessionsPreventsLogin(false).expiredUrl("/login.html");
        ((HttpSecurity)((HttpSecurity)((FormLoginConfigurer)http.formLogin().failureHandler(this.failureHandler)).and()).logout().invalidateHttpSession(true).logoutUrl("/logout").logoutSuccessHandler(this.getCustomLogoutSuccessHandler()).and()).csrf().disable();
        SecurityConfiguration.configAnonymousMatchers("/*/front/**");
    }

    @Bean(value={"customLogoutSuccessHandler"})
    protected LogoutSuccessHandler getCustomLogoutSuccessHandler() {
        CustomLogoutSuccessHandler handler = new CustomLogoutSuccessHandler();
        handler.setDefaultTargetUrl("/logout.html");
        return handler;
    }

    private Filter getCustomFilterSecurityInterceptor() {
        FilterSecurityInterceptor filter = new FilterSecurityInterceptor();
        filter.setAuthenticationManager(this.getAuthenticationManager());
        filter.setAccessDecisionManager((AccessDecisionManager)this.customAccessDecisionManager);
        filter.setSecurityMetadataSource((FilterInvocationSecurityMetadataSource)this.customFilterInvocationSecurityMetadataSource);
        return filter;
    }

    @Bean(value={"captchaAuthenticaionFilter"})
    protected Filter getCaptchaAuthenticaionFilter() {
        CustomCaptchaAuthenticationFilter filter = new CustomCaptchaAuthenticationFilter();
        filter.setAuthenticationManager(this.getAuthenticationManager());
        filter.setAuthenticationFailureHandler(this.failureHandler);
        filter.setAuthenticationSuccessHandler(this.successHandler);
        filter.setFilterProcessesUrl("/loginForSpringSecurity");
        return filter;
    }

    @Bean(value={"authenticationManager"})
    protected AuthenticationManager getAuthenticationManager() {
        List<AuthenticationProvider> providers = Arrays.asList(this.getAuthenticationProvider());
        ProviderManager authenticationManager = new ProviderManager(providers);
        return authenticationManager;
    }

    @Bean(value={"daoAuthenticationProvider"})
    protected AuthenticationProvider getAuthenticationProvider() {
        CustomDaoAuthenticationProvider authenticationProvider = new CustomDaoAuthenticationProvider();
        authenticationProvider.setPasswordEncoder(this.passwordEncoder);
        authenticationProvider.setUserDetailsService(this.userDetailsService);
        authenticationProvider.setHideUserNotFoundExceptions(true);
        return authenticationProvider;
    }

    @Bean(value={"customExceptionTranslationFilter"})
    protected Filter getExceptionTranslationFilter() {
        ExceptionTranslationFilter filter = new ExceptionTranslationFilter(this.getAuthenticationEntryPoint());
        filter.setAccessDeniedHandler((AccessDeniedHandler)this.accessDeniedHandler);
        return filter;
    }

    @Bean(value={"authenticationEntryPoint"})
    protected AuthenticationEntryPoint getAuthenticationEntryPoint() {
        CustomAuthenticationEntryPoint entryPoint = new CustomAuthenticationEntryPoint("/login.html");
        return entryPoint;
    }

    @Bean(value={"localeChangeAndSaveFilter"})
    protected Filter getLocaleChangeAndSaveFilter() {
        return new LocaleChangeAndSaveFilter();
    }

    @Bean(value={"customInvalidSessionStrategy"})
    protected InvalidSessionStrategy getInvalidSessionStrategy() {
        CustomInvalidSessionStrategy strategy = new CustomInvalidSessionStrategy("/login.html");
        return strategy;
    }
}

