/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.auth.service.impl;

import com.els.base.auth.dao.MenuMapper;
import com.els.base.auth.entity.Menu;
import com.els.base.auth.entity.MenuExample;
import com.els.base.auth.entity.OperatorExample;
import com.els.base.auth.entity.RoleRight;
import com.els.base.auth.entity.RoleRightExample;
import com.els.base.auth.service.ButtonService;
import com.els.base.auth.service.MenuService;
import com.els.base.auth.service.OperatorService;
import com.els.base.auth.service.RoleRightService;
import com.els.base.auth.utils.AuthConstant;
import com.els.base.auth.utils.MenuComparator;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MenuServiceImpl
implements MenuService {
    private static final int MAX_CALLCOUNT = 5;
    @Resource
    private MenuMapper menuMapper;
    @Resource
    private RoleRightService roleRightService;
    @Resource
    private OperatorService operatorService;
    @Resource
    private ButtonService buttonService;

    @Transactional
    @CacheEvict(value={"menu"}, allEntries=true)
    public void addObj(Menu menu) {
        MenuExample menuExample = new MenuExample();
        menuExample.createCriteria().andMenuCodeEqualTo(menu.getMenuCode());
        if (this.menuMapper.countByExample(menuExample) > 0) {
            throw new CommonException("\u83dc\u5355code\u503c\u5df2\u5b58\u5728", "base_is_exists", new Object[]{"code\u503c"});
        }
        if (menu.getMenuCode().length() > 30) {
            throw new CommonException("\u83dc\u5355\u680f\u76ee\u4ee3\u7801\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc730", "length_canot_exceed", new Object[]{"\u83dc\u5355\u680f\u76ee\u4ee3\u7801", "30"});
        }
        if (menu.getMenuName().length() > 100) {
            throw new CommonException("\u540d\u79f0\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7100", "length_canot_exceed", new Object[]{"\u540d\u79f0", "100"});
        }
        this.menuMapper.insertSelective(menu);
    }

    @CacheEvict(value={"menu"}, allEntries=true)
    public void deleteObjById(String menuId) {
        this.deleteChildrenMenu(menuId, 0);
    }

    @Transactional
    @CacheEvict(value={"menu"}, allEntries=true)
    public void modifyObj(Menu menu) {
        if (StringUtils.isBlank((String)menu.getId())) {
            throw new CommonException("\u83dc\u5355id\u4e0d\u80fd\u4e3a\u7a7a", "id_is_blank");
        }
        if (menu.getMenuCode().length() > 30) {
            throw new CommonException("\u83dc\u5355\u680f\u76ee\u4ee3\u7801\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc730", "length_canot_exceed", new Object[]{"\u83dc\u5355\u680f\u76ee\u4ee3\u7801", "30"});
        }
        if (menu.getMenuName().length() > 100) {
            throw new CommonException("\u540d\u79f0\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7100", "length_canot_exceed", new Object[]{"\u540d\u79f0", "100"});
        }
        Menu source = this.queryObjById(menu.getId());
        if (StringUtils.isNotBlank((String)menu.getMenuCode()) && !menu.getMenuCode().equals(source.getMenuCode())) {
            MenuExample menuExample = new MenuExample();
            menuExample.createCriteria().andMenuCodeEqualTo(menu.getMenuCode());
            if (this.menuMapper.countByExample(menuExample) > 0) {
                throw new CommonException("\u83dc\u5355code\u503c\u5df2\u5b58\u5728", "base_is_exists", new Object[]{"code\u503c"});
            }
        }
        this.menuMapper.updateByPrimaryKeySelective(menu);
    }

    @Cacheable(value={"menu"}, keyGenerator="redisKeyGenerator")
    public Menu queryObjById(String id) {
        return this.menuMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"menu"}, keyGenerator="redisKeyGenerator")
    public List<Menu> queryAllObjByExample(MenuExample example) {
        return this.menuMapper.selectByExample(example);
    }

    @Cacheable(value={"menu"}, keyGenerator="redisKeyGenerator")
    public PageView<Menu> queryObjByPage(MenuExample example) {
        PageView<Menu> pageView = example.getPageView();
        List<Menu> list = this.menuMapper.selectByExampleByPage(example);
        pageView.setQueryResult(list);
        return pageView;
    }

    private List<Menu> getChildrendMenu(String parentMenuId, List<String> visiableMenuId, List<String> authedMenuIds, boolean isFilter) {
        if (visiableMenuId == null) {
            if (isFilter) {
                return null;
            }
            visiableMenuId = new ArrayList<String>();
        }
        if (authedMenuIds == null) {
            authedMenuIds = new ArrayList<String>();
        }
        MenuExample menuExample = new MenuExample();
        MenuExample.Criteria criteria = menuExample.createCriteria().andParentIdEqualTo(parentMenuId);
        if (isFilter) {
            criteria.andIdIn((List)visiableMenuId);
        }
        menuExample.setOrderByClause("sort_no ASC");
        List<Menu> childrenMenus = this.menuMapper.selectByExample(menuExample);
        for (int i = 0; CollectionUtils.isNotEmpty(childrenMenus) && i < childrenMenus.size(); ++i) {
            Menu subMenu = childrenMenus.get(i);
            if (!authedMenuIds.equals(visiableMenuId) && isFilter) {
                subMenu.setAuthorized(authedMenuIds.contains(subMenu.getId()));
            }
            subMenu.setChildren(this.getChildrendMenu(subMenu.getId(), visiableMenuId, authedMenuIds, isFilter));
        }
        return childrenMenus;
    }

    private void deleteChildrenMenu(String menuId, int callCount) {
        if (++callCount > 5) {
            return;
        }
        MenuExample menuExample = new MenuExample();
        menuExample.createCriteria().andParentIdEqualTo(menuId);
        menuExample.setOrderByClause("sort_no ASC");
        List<Menu> menuChildren = this.menuMapper.selectByExample(menuExample);
        for (Menu subMenu : menuChildren) {
            this.deleteChildrenMenu(subMenu.getId(), callCount);
        }
        this.menuMapper.deleteByPrimaryKey(menuId);
        OperatorExample operatorExample = new OperatorExample();
        operatorExample.createCriteria().andMenuIdEqualTo(menuId);
        this.operatorService.deleteByExample(operatorExample);
        this.buttonService.deleteObjByMenuId(menuId);
    }

    @Override
    @Cacheable(value={"menu"}, keyGenerator="redisKeyGenerator")
    public List<Menu> queryAllMenuWithAuthRoleIds(List<String> currentRoleIds, List<String> targetRoleIds) {
        List<Menu> currentMenus;
        if (CollectionUtils.isEmpty(currentRoleIds)) {
            throw new CommonException("\u5f53\u524d\u7684\u89d2\u8272\u4e3a\u7a7a");
        }
        MenuExample menuExample = new MenuExample();
        MenuExample.Criteria criteria = menuExample.createCriteria();
        if (!currentRoleIds.contains(AuthConstant.SYS_MANAGER_ROLE.getId())) {
            List<String> currentMenuIds = this.queryMenuIdByRoleId(currentRoleIds);
            if (CollectionUtils.isEmpty(currentMenuIds)) {
                return null;
            }
            criteria.andIdIn((List)currentMenuIds);
        }
        if (CollectionUtils.isEmpty(currentMenus = this.queryAllObjByExample(menuExample))) {
            return null;
        }
        if (!targetRoleIds.contains(AuthConstant.SYS_MANAGER_ROLE.getId()) && !currentRoleIds.equals(targetRoleIds)) {
            List<String> targetMenuId = this.queryMenuIdByRoleId(targetRoleIds);
            for (Menu menu : currentMenus) {
                menu.setAuthorized(targetMenuId.contains(menu.getId()));
            }
        }
        ArrayList<Menu> allMenu = new ArrayList<Menu>();
        for (Menu menu : currentMenus) {
            if (!"1".equals(menu.getParentId())) continue;
            allMenu.add(menu);
            List<Menu> children = this.findChildren(menu, currentMenus);
            menu.setChildren(children);
        }
        Collections.sort(allMenu, new MenuComparator());
        this.buttonService.setAuthDataInMenu(allMenu, currentRoleIds, targetRoleIds);
        this.operatorService.setAuthDataInMenu(allMenu, currentRoleIds, targetRoleIds);
        return allMenu;
    }

    private List<Menu> findChildren(Menu parent, List<Menu> currentMenus) {
        ArrayList<Menu> allMenu = new ArrayList<Menu>();
        for (Menu child : currentMenus) {
            if (!parent.getId().equals(child.getParentId())) continue;
            allMenu.add(child);
            List<Menu> children = this.findChildren(child, currentMenus);
            child.setChildren(children);
        }
        Collections.sort(allMenu, new MenuComparator());
        return allMenu;
    }

    @Override
    @Cacheable(value={"menu"}, keyGenerator="redisKeyGenerator")
    public List<Menu> queryAuthedMenuForRoleIds(List<String> roleIds) {
        return this.queryAllMenuWithAuthRoleIds(roleIds, roleIds);
    }

    private List<String> queryMenuIdByRoleId(List<String> roleIds) {
        RoleRightExample roleRightExample = new RoleRightExample();
        roleRightExample.createCriteria().andRoleIdIn((List)roleIds).andTypeEqualTo("menu");
        List roleRightList = this.roleRightService.queryAllObjByExample((IExample)roleRightExample);
        ArrayList<String> authMenuIds = new ArrayList<String>();
        for (RoleRight roleRight : roleRightList) {
            authMenuIds.add(roleRight.getKeyId());
        }
        return authMenuIds;
    }
}

