/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.auth.service.impl;

import com.els.base.auth.dao.UserGroupMapper;
import com.els.base.auth.dao.UserGroupUserRefMapper;
import com.els.base.auth.entity.UserGroup;
import com.els.base.auth.entity.UserGroupExample;
import com.els.base.auth.entity.UserGroupUserRef;
import com.els.base.auth.entity.UserGroupUserRefExample;
import com.els.base.auth.service.UserGroupService;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.user.User;
import com.els.base.core.entity.user.UserExample;
import com.els.base.core.service.user.UserService;
import com.els.base.core.utils.Constant;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service(value="userGroupService")
public class UserGroupServiceImpl
implements UserGroupService {
    @Resource
    protected UserGroupMapper userGroupMapper;
    @Resource
    protected UserGroupUserRefMapper userGroupUserRefMapper;
    @Resource
    protected UserService userService;

    @CacheEvict(value={"userGroupCache"}, allEntries=true)
    public void addObj(UserGroup t) {
        this.userGroupMapper.insertSelective(t);
    }

    @CacheEvict(value={"userGroupCache"}, allEntries=true)
    public void deleteObjById(String id) {
        this.userGroupMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"userGroupCache"}, allEntries=true)
    public void modifyObj(UserGroup t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.userGroupMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"userGroupCache"}, keyGenerator="redisKeyGenerator")
    public UserGroup queryObjById(String id) {
        return this.userGroupMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"userGroupCache"}, keyGenerator="redisKeyGenerator")
    public List<UserGroup> queryAllObjByExample(UserGroupExample example) {
        return this.userGroupMapper.selectByExample(example);
    }

    @Cacheable(value={"userGroupCache"}, keyGenerator="redisKeyGenerator")
    public PageView<UserGroup> queryObjByPage(UserGroupExample example) {
        PageView<UserGroup> pageView = example.getPageView();
        pageView.setQueryResult(this.userGroupMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"userGroupCache"}, allEntries=true)
    public void addUserIntoUserGroup(String userId, String userGroupId) {
        UserGroupUserRef ref = new UserGroupUserRef();
        ref.setUserId(userId);
        ref.setUserGroupId(userGroupId);
        this.userGroupUserRefMapper.insertSelective(ref);
    }

    @Override
    @Cacheable(value={"userGroupCache"}, keyGenerator="redisKeyGenerator")
    public UserGroup queryUserGroupsByUserId(String userId) {
        UserGroupUserRefExample userUserGroupRefExample = new UserGroupUserRefExample();
        userUserGroupRefExample.createCriteria().andUserIdEqualTo(userId);
        List<UserGroupUserRef> refList = this.userGroupUserRefMapper.selectByExample(userUserGroupRefExample);
        if (CollectionUtils.isEmpty(refList)) {
            return null;
        }
        return this.queryParents(refList.get(0).getUserGroupId());
    }

    @Override
    @Cacheable(value={"userGroupCache"}, keyGenerator="redisKeyGenerator")
    public List<User> queryUserByUserGroupId(String userGroupId) {
        List<UserGroup> userGroups = this.queryAllChildren(userGroupId);
        ArrayList<String> userGroupIds = new ArrayList<String>();
        for (UserGroup o : userGroups) {
            userGroupIds.add(o.getId());
        }
        UserGroupUserRefExample refExample = new UserGroupUserRefExample();
        refExample.createCriteria().andUserGroupIdIn(userGroupIds);
        List<UserGroupUserRef> refList = this.userGroupUserRefMapper.selectByExample(refExample);
        ArrayList<String> userIds = new ArrayList<String>();
        for (UserGroupUserRef ref : refList) {
            userIds.add(ref.getUserId());
        }
        UserExample userExample = new UserExample();
        userExample.createCriteria().andIdIn(userIds).andIsEnableEqualTo(Constant.YES_INT);
        return this.userService.queryAllObjByExample((IExample)userExample);
    }

    @Override
    @Cacheable(value={"userGroupCache"}, keyGenerator="redisKeyGenerator")
    public UserGroup queryParents(String userGroupId) {
        UserGroup current = this.userGroupMapper.selectByPrimaryKey(userGroupId);
        UserGroup parent = current.getParent();
        while (parent != null && parent.getParentId() != null && Constant.YES_INT.equals(parent.getIsEnable())) {
            UserGroup parentTmp = this.userGroupMapper.selectByPrimaryKey(parent.getId());
            parent.setParent(parentTmp);
            parent = parentTmp;
        }
        return current;
    }

    @Override
    @Cacheable(value={"userGroupCache"}, keyGenerator="redisKeyGenerator")
    public List<UserGroup> queryAllChildren(String userGroupId) {
        UserGroupExample userGroupExample = new UserGroupExample();
        userGroupExample.createCriteria().andParentIdEqualTo(userGroupId).andIsEnableEqualTo(Constant.YES_INT);
        List<UserGroup> children = this.userGroupMapper.selectByExample(userGroupExample);
        if (CollectionUtils.isEmpty(children)) {
            return null;
        }
        ArrayList tmpChildren = new ArrayList();
        for (UserGroup o : children) {
            List<UserGroup> subChildren = this.queryAllChildren(o.getId());
            if (CollectionUtils.isEmpty(subChildren)) continue;
            CollectionUtils.addAll(tmpChildren, subChildren.iterator());
        }
        CollectionUtils.addAll(children, tmpChildren.iterator());
        return children;
    }

    @Override
    @Cacheable(value={"userGroupCache"}, keyGenerator="redisKeyGenerator")
    public List<UserGroup> querySubChildren(String userGroupId) {
        UserGroupExample userGroupExample = new UserGroupExample();
        userGroupExample.createCriteria().andParentIdEqualTo(userGroupId).andIsEnableEqualTo(Constant.YES_INT);
        return this.userGroupMapper.selectByExample(userGroupExample);
    }
}

