/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.auth.service.impl;

import com.els.base.auth.dao.UserRoleMapper;
import com.els.base.auth.entity.UserRole;
import com.els.base.auth.entity.UserRoleExample;
import com.els.base.auth.service.UserRoleService;
import com.els.base.core.entity.PageView;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="userRoleService")
public class UserRoleServiceImpl
implements UserRoleService {
    @Autowired
    private UserRoleMapper userRoleMapper;

    @CacheEvict(value={"roleCache", "roleRightCache"}, allEntries=true)
    public void addObj(UserRole userRole) {
        Date date = new Date();
        userRole.setCreateTime(date);
        this.userRoleMapper.insertSelective(userRole);
    }

    @CacheEvict(value={"roleCache", "roleRightCache"}, allEntries=true)
    public void deleteObjById(String id) {
        this.userRoleMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"roleCache", "roleRightCache"}, allEntries=true)
    public void modifyObj(UserRole userRole) {
        if (userRole == null || StringUtils.isBlank((String)userRole.getId())) {
            throw new IllegalArgumentException("id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.userRoleMapper.updateByPrimaryKeySelective(userRole);
    }

    @Override
    @Cacheable(value={"roleCache"}, keyGenerator="redisKeyGenerator")
    public List<UserRole> queryUserRoleList(String userId) {
        UserRoleExample example = new UserRoleExample();
        example.createCriteria().andUserIdEqualTo(userId);
        return this.queryAllObjByExample(example);
    }

    @Override
    @Cacheable(value={"roleCache"}, keyGenerator="redisKeyGenerator")
    public List<String> queryUserOwnRoleIds(String userId) {
        UserRoleExample example = new UserRoleExample();
        example.createCriteria().andUserIdEqualTo(userId);
        List<UserRole> list = this.userRoleMapper.selectByExample(example);
        ArrayList<String> ids = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            ids.add(list.get(i).getRoleId());
        }
        return ids;
    }

    @Override
    @CacheEvict(value={"roleCache", "roleRightCache"}, allEntries=true)
    public void deleteAllUserRole(String userId) {
        UserRoleExample example = new UserRoleExample();
        example.createCriteria().andUserIdEqualTo(userId);
        this.userRoleMapper.deleteByExample(example);
    }

    @Cacheable(value={"roleCache"}, keyGenerator="redisKeyGenerator")
    public UserRole queryObjById(String id) {
        return this.userRoleMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"roleCache"}, keyGenerator="redisKeyGenerator")
    public List<UserRole> queryAllObjByExample(UserRoleExample example) {
        return this.userRoleMapper.selectByExample(example);
    }

    @Cacheable(value={"roleCache"}, keyGenerator="redisKeyGenerator")
    public PageView<UserRole> queryObjByPage(UserRoleExample example) {
        PageView<UserRole> pageView = example.getPageView();
        pageView.setQueryResult(this.userRoleMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @Transactional
    @CacheEvict(value={"roleCache", "roleRightCache"}, allEntries=true)
    public void resetUserRole(String userId, String[] roleIds) {
        this.deleteAllUserRole(userId);
        for (String roleId : roleIds) {
            UserRole userRole = new UserRole();
            userRole.setUserId(userId);
            userRole.setRoleId(roleId);
            this.addObj(userRole);
        }
    }

    @Override
    @Cacheable(value={"roleCache"}, keyGenerator="redisKeyGenerator")
    public List<String> queryUserIdsForRoleId(String roleId) {
        UserRoleExample example = new UserRoleExample();
        example.createCriteria().andRoleIdEqualTo(roleId);
        List<UserRole> list = this.userRoleMapper.selectByExample(example);
        ArrayList<String> ids = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            ids.add(list.get(i).getUserId());
        }
        return ids;
    }
}

