package com.els.base.auth.entity;

import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(value="url请求")
public class Operator implements AuthorizationData {
	
//	############################
	@ApiModelProperty("是否有权限")
	private boolean authorized = false;
	
    @Override
    public boolean getAuthorized() {
		return authorized;
	}

	@Override
    public void setAuthorized(boolean authorized) {
		this.authorized = authorized;
	}

	@Override
	public String getType() {
		return AuthorizationData.TYPE_OPERATOR;
	}
	
//	############################
	
    @ApiModelProperty("url请求Id")
    private String id;

    @ApiModelProperty("url请求名称")
    private String operName;

    @ApiModelProperty("url请求码")
    private String operCode;

    @ApiModelProperty("url请求地址")
    private String operUrl;

    @ApiModelProperty("请求属于的菜单页面的Id")
    private String menuId;

    @ApiModelProperty("请求属于的菜单页面名称")
    private String menuName;

    @ApiModelProperty("请求属于的菜单页面编码")
    private String menuCode;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("更新时间")
    private Date updateTime;

    @ApiModelProperty("项目id")
    private String projectId;

    private static final long serialVersionUID = 1L;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getOperName() {
        return operName;
    }

    public void setOperName(String operName) {
        this.operName = operName == null ? null : operName.trim();
    }

    public String getOperCode() {
        return operCode;
    }

    public void setOperCode(String operCode) {
        this.operCode = operCode == null ? null : operCode.trim();
    }

    public String getOperUrl() {
        return operUrl;
    }

    public void setOperUrl(String operUrl) {
        this.operUrl = operUrl == null ? null : operUrl.trim();
    }

    public String getMenuId() {
        return menuId;
    }

    public void setMenuId(String menuId) {
        this.menuId = menuId == null ? null : menuId.trim();
    }

    public String getMenuName() {
        return menuName;
    }

    public void setMenuName(String menuName) {
        this.menuName = menuName == null ? null : menuName.trim();
    }

    public String getMenuCode() {
        return menuCode;
    }

    public void setMenuCode(String menuCode) {
        this.menuCode = menuCode == null ? null : menuCode.trim();
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId == null ? null : projectId.trim();
    }
}