package com.els.base.auth.service;

import java.util.List;

import com.els.base.auth.entity.UserRole;
import com.els.base.auth.entity.UserRoleExample;
import com.els.base.core.service.BaseService;

/**
 * Created by LiBing on 2014/6/10.
 */
public interface UserRoleService extends BaseService<UserRole, UserRoleExample, String> {

    /**
     * 根据用户Id获取用户拥有的角色信息
     * @param userId
     * @return
     */
    List<UserRole> queryUserRoleList(String userId);
    
    /**
     * 根据用户Id查询用户所拥有的角色Id
     * @param userId
     * @return
     */
    List<String> queryUserOwnRoleIds(String userId);
    
    /**
     * 根据用户Id查询用户所拥有的角色Id
     * @param roleId
     * @return
     */
    List<String> queryUserIdsForRoleId(String roleId);

    /**
     * 根据用户Id删除用户所拥有的角色信息
     * @param userId
     */
    void deleteAllUserRole(String userId);
    
    void resetUserRole(String userId, String[] roleIds);
   
}
