package com.els.base.auth.web.controller;

import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.els.base.auth.entity.Button;
import com.els.base.auth.entity.ButtonExample;
import com.els.base.auth.service.ButtonService;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;

@Api(value="权限管理-按钮配置")
@Controller
@RequestMapping("button")
public class ButtonController {
    @Resource
    protected ButtonService buttonService;

    @ApiOperation(httpMethod="POST", value="创建按钮配置")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody Button button) {
    	Assert.isNotBlank(button.getBtnCode(), "code值不能为空");
    	Assert.isNotBlank(button.getMenuId(), "menuId不能为空");
    	
        this.buttonService.addObj(button);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="编辑按钮配置")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody Button button) {
        if (StringUtils.isBlank(button.getId())) {
            throw new CommonException("id 为空，保存失败");
        }
        
        this.buttonService.modifyObj(button);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="删除按钮配置")
    @RequestMapping("service/deleteById")
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        if (StringUtils.isBlank(id)) {
            throw new CommonException("删除失败,id不能为空");
        }
        this.buttonService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="查询按钮配置")
    @ApiImplicitParams({ 
    	@ApiImplicitParam( name = "pageNo",required = false,value = "所在页", paramType = "query", dataType = "String", defaultValue = "0" ),  
		@ApiImplicitParam( name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10" ),  
		@ApiImplicitParam( name = "menuId", required = false, value = "按钮所在的菜单页面", paramType = "query", dataType = "menuId" )  
	}) 
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<Button>> findByPage( 
		@RequestParam(defaultValue="0") int pageNo,  
		@RequestParam(defaultValue="10") int pageSize, 
		@RequestParam(required=true) String menuId) {
    	
        ButtonExample example = new ButtonExample();
        example.setPageView(new PageView<Button>(pageNo, pageSize));
        
        ButtonExample.Criteria criteria = example.createCriteria();
        criteria.andMenuIdEqualTo(menuId);
        
        PageView<Button> pageData = this.buttonService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
    
    @ApiOperation(httpMethod="POST", value="根据菜单编码查询按钮配置")
    @ApiImplicitParams({ 
		@ApiImplicitParam( name = "menuCode", required = false, value = "菜单页面code", paramType = "query", dataType = "menuId" )  
	}) 
    @RequestMapping("service/findByMenuCode")
    @ResponseBody
    public ResponseResult<List<Button>> findByMenuCode(@RequestParam(required=true) String menuCode) {
    	
    	ButtonExample example = new ButtonExample();
    	ButtonExample.Criteria criteria = example.createCriteria();
    	criteria.andMenuCodeEqualTo(menuCode);
    	
    	return ResponseResult.success(this.buttonService.queryAllObjByExample(example));
    }
}