package com.els.base.auth.web.security.impl;

import java.io.IOException;
import java.util.List;

import javax.annotation.Resource;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.lang.StringUtils;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.SavedRequestAwareAuthenticationSuccessHandler;
import org.springframework.stereotype.Component;

import com.els.base.auth.entity.User;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.project.Project;
import com.els.base.core.entity.project.ProjectExample;
import com.els.base.core.service.project.ProjectService;
import com.els.base.core.utils.Assert;
import com.els.base.utils.http.HttpResponseUtils;

/**
 * 登录成功处理器，区分页面登录，与ajax登录的不同的结果
 * 
 * @author hzy
 *
 */
@Component("customAuthenticationSuccessHandler")
public class CustomAuthenticationSuccessHandler extends SavedRequestAwareAuthenticationSuccessHandler {

    @Resource
    private ProjectService projectService;

    @Override
    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response,
            Authentication authentication) throws IOException, ServletException {
        User user = (User) authentication.getPrincipal();
        HttpSession session = request.getSession();

        session.setAttribute("userId", user.getId());
        // 根据登录用户获取跳转项目路由
        if (StringUtils.isBlank(user.getProjectCode())) {
            HttpResponseUtils.responseResutlAsJson(response, ResponseResult.success());
            return;
        }

        ProjectExample projectExample = new ProjectExample();
        projectExample.createCriteria().andProjectCodeEqualTo(user.getProjectCode());
        List<Project> projectList = projectService.queryAllObjByExample(projectExample);

        String loginSuccessPage = null;
        Assert.isNotEmpty(projectList, "用户登录环境的项目编码不匹配!");
//        if (CollectionUtils.isNotEmpty(projectList)) {
            Project project = projectList.get(0);
            if (project != null) {
            	loginSuccessPage = project.getLoginSuccessPage();
			}
            String protocol = request.getScheme();
            loginSuccessPage = loginSuccessPage.replaceAll("(http|htpps)", protocol);
//        }
        // if (HttpRequestUtils.isAjaxRequest(request)) {
        HttpResponseUtils.responseResutlAsJson(response, ResponseResult.success(loginSuccessPage));
        return;
        // }
        //
        // super.onAuthenticationSuccess(request, response, authentication);
    }

}
