-- ----------------------------
-- 按钮
-- ----------------------------
CREATE TABLE `T_BASE_AUTH_BUTTON`
(
    `ID`          varchar(32)  NOT NULL COMMENT '按钮id',
    `BTN_NAME`    varchar(255) NOT NULL COMMENT '按钮名称',
    `BTN_CODE`    varchar(255) NOT NULL COMMENT '按钮编码',
    `OPER_ICON`   varchar(255) DEFAULT NULL COMMENT '按钮的icon',
    `MENU_ID`     varchar(32)  NOT NULL COMMENT '按钮属于哪个菜单页面',
    `MENU_NAME`   varchar(255) DEFAULT NULL COMMENT '按钮属于的菜单页面',
    `MENU_CODE`   varchar(255) DEFAULT NULL COMMENT '按钮属于的菜单code',
    `CREATE_TIME` datetime(6)  DEFAULT NULL COMMENT '创建时间',
    `UPDATE_TIME` datetime(6)  DEFAULT NULL COMMENT '更新时间',
    `PROJECT_ID`  varchar(32)  DEFAULT NULL COMMENT '项目id',
    PRIMARY KEY (`ID`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4 COMMENT ='按钮配置';

-- ----------------------------
-- 用户组和用户的关系
-- ----------------------------
CREATE TABLE `T_BASE_AUTH_GROUP_ROLE_REF`
(
    `ID`            varchar(32) NOT NULL COMMENT '主键',
    `USER_GROUP_ID` varchar(32) DEFAULT NULL COMMENT '组织id',
    `ROLE_ID`       varchar(32) DEFAULT NULL COMMENT '角色id',
    PRIMARY KEY (`ID`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4 COMMENT ='用户组与角色的关系';



CREATE TABLE `T_BASE_AUTH_ROLE`
(
    `ID`             varchar(32)  NOT NULL COMMENT 'ID',
    `ROLE_NAME`      varchar(50)  NOT NULL COMMENT '角色名称',
    `ROLE_LEVEL`     int(11)      NOT NULL DEFAULT '200' COMMENT '角色级别，系统级别100，用户自定义200',
    `ROLE_CODE`      varchar(20)           DEFAULT NULL COMMENT '角色编码',
    `CREATE_USER_ID` varchar(32)           DEFAULT NULL COMMENT '角色的创建者Id',
    `CREATE_TIME`    timestamp(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6) ON UPDATE CURRENT_TIMESTAMP(6) COMMENT '创建时间',
    `UPDATE_TIME`    timestamp(6) NULL     DEFAULT NULL COMMENT '更新时间',
    `PROJECT_ID`     varchar(32)           DEFAULT NULL COMMENT '项目ID',
    `COMPANY_ID`     varchar(32)           DEFAULT NULL COMMENT '公司ID',
    PRIMARY KEY (`ID`) USING BTREE
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4 COMMENT ='权限管理-角色管理';
