/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.auth.web.controller;

import com.els.base.auth.entity.Button;
import com.els.base.auth.entity.ButtonExample;
import com.els.base.auth.service.ButtonService;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u6743\u9650\u7ba1\u7406-\u6309\u94ae\u914d\u7f6e")
@Controller
@RequestMapping(value={"button"})
public class ButtonController {
    @Resource
    protected ButtonService buttonService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u6309\u94ae\u914d\u7f6e")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody Button button) {
        Assert.isNotBlank((String)button.getBtnCode(), (String)"code\u503c\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)button.getMenuId(), (String)"menuId\u4e0d\u80fd\u4e3a\u7a7a");
        this.buttonService.addObj(button);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u6309\u94ae\u914d\u7f6e")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody Button button) {
        if (StringUtils.isBlank((String)button.getId())) {
            throw new CommonException("id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        }
        this.buttonService.modifyObj(button);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u6309\u94ae\u914d\u7f6e")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        if (StringUtils.isBlank((String)id)) {
            throw new CommonException("\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.buttonService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u6309\u94ae\u914d\u7f6e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="menuId", required=false, value="\u6309\u94ae\u6240\u5728\u7684\u83dc\u5355\u9875\u9762", paramType="query", dataType="menuId")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<Button>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestParam(required=true) String menuId) {
        ButtonExample example = new ButtonExample();
        example.setPageView((PageView<Button>)new PageView(pageNo, pageSize));
        ButtonExample.Criteria criteria = example.createCriteria();
        criteria.andMenuIdEqualTo(menuId);
        PageView pageData = this.buttonService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u6839\u636e\u83dc\u5355\u7f16\u7801\u67e5\u8be2\u6309\u94ae\u914d\u7f6e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="menuCode", required=false, value="\u83dc\u5355\u9875\u9762code", paramType="query", dataType="menuId")})
    @RequestMapping(value={"service/findByMenuCode"})
    @ResponseBody
    public ResponseResult<List<Button>> findByMenuCode(@RequestParam(required=true) String menuCode) {
        ButtonExample example = new ButtonExample();
        ButtonExample.Criteria criteria = example.createCriteria();
        criteria.andMenuCodeEqualTo(menuCode);
        return ResponseResult.success((Object)this.buttonService.queryAllObjByExample((IExample)example));
    }
}

