/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.bill.service.impl;

import com.els.base.accountGroup.entity.SupGroup;
import com.els.base.accountGroup.entity.SupGroupExample;
import com.els.base.accountGroup.service.SupGroupService;
import com.els.base.bill.entity.Bill;
import com.els.base.bill.entity.BillExample;
import com.els.base.bill.entity.BillItem;
import com.els.base.bill.entity.BillItemExample;
import com.els.base.bill.service.BillItemService;
import com.els.base.bill.service.BillService;
import com.els.base.bill.service.BillTimeTaskService;
import com.els.base.bill.utils.BillSendStatus;
import com.els.base.bill.utils.BillStatusConfirmEnum;
import com.els.base.bill.utils.CalculateBillUtil;
import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyExample;
import com.els.base.company.service.CompanySapRelationService;
import com.els.base.company.service.CompanyService;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.conditions.service.ConditionsService;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.user.User;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.deduction.entity.Deduction;
import com.els.base.deduction.entity.DeductionExample;
import com.els.base.deduction.service.DeductionService;
import com.els.base.finance.service.SapBillService;
import com.els.base.finance.service.VoucherTimeTaskService;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import com.els.base.taxclassify.service.TaxClassifyService;
import com.els.base.util.BillBusinessTypeEnum;
import com.els.base.utils.uuid.UUIDGenerator;
import com.els.base.voucher.entity.BillVoucher;
import com.els.base.voucher.entity.BillVoucherExample;
import com.els.base.voucher.service.BillVoucherService;
import com.els.liby.organization.entity.Organization;
import com.els.liby.organization.entity.OrganizationExample;
import com.els.liby.organization.service.OrganizationService;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BillTimeTaskServiceImpl
implements BillTimeTaskService {
    Logger logger = LoggerFactory.getLogger(BillTimeTaskServiceImpl.class);
    @Resource
    protected BillService billService;
    @Resource
    protected BillVoucherService billVoucherService;
    @Resource
    protected BillItemService billItemService;
    @Resource
    private SapBillService sapBillService;
    @Resource
    private TaxClassifyService taxClassifyService;
    @Resource
    private OrganizationService organizationService;
    @Resource
    private ConditionsService conditionsService;
    @Resource
    private DeductionService deductionService;
    @Resource
    protected CompanyService companyService;
    @Resource
    protected VoucherTimeTaskService voucherTimeTaskService;
    @Resource
    protected CompanySapRelationService companySapRelationService;
    @Resource
    protected CompanyUserRefService companyUserRefService;
    @Resource
    protected SupGroupService supGroupService;

    @Override
    @Transactional
    @Cacheable(value={"bill"}, keyGenerator="redisKeyGenerator")
    public void createBill() throws ParseException {
        String startTimeStr = "2018-07-01";
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Date startTime = this.getStartTime(format, startTimeStr);
        Date endTime = new Date();
        String endTimeStr = DateFormatUtils.format((Date)endTime, (String)"yyyy-MM-dd");
        List<Company> companies = this.filter();
        List coms = companies.stream().filter(i -> "C001".equals(i.getSupAccountGroup())).collect(Collectors.toList());
        for (Company company : coms) {
            List<String> codeList = this.findCompanyCodeList();
            this.initBill(company.getCompanySapCode(), codeList, startTime, startTimeStr, endTime, endTimeStr);
        }
    }

    @Override
    @Transactional
    @Cacheable(value={"bill"}, keyGenerator="redisKeyGenerator")
    public void createBillByMon() throws ParseException {
        String startTimeStr = "2018-07-01";
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Date startTime = this.getStartTime(format, startTimeStr);
        String endTimeStr = new DateTime().minusDays(1).toString("yyyy-MM-dd");
        Date endTime = this.getStartTime(format, endTimeStr);
        SupGroupExample example = new SupGroupExample();
        example.createCriteria().andIsEnableEqualTo(Constant.YES_INT).andSupGroupNameEqualTo("\u6bcf\u5468\u4e00");
        List list = this.supGroupService.queryAllObjByExample((IExample)example);
        for (SupGroup supGroup : list) {
            List<String> codeList = this.findCompanyCodeList();
            this.initBill(supGroup.getSupCompanySapCode(), codeList, startTime, startTimeStr, endTime, endTimeStr);
        }
    }

    @Override
    @Transactional
    @Cacheable(value={"bill"}, keyGenerator="redisKeyGenerator")
    public void createBillC002() throws ParseException {
        String startTimeStr = "2018-07-01";
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Date startTime = this.getStartTime(format, startTimeStr);
        Calendar cale = Calendar.getInstance();
        cale.set(5, 0);
        String endTimeStr = DateFormatUtils.format((Date)cale.getTime(), (String)"yyyy-MM-dd");
        Date endTime = this.getStartTime(format, endTimeStr);
        List<Company> companies = this.filter();
        List coms = companies.stream().filter(i -> "C002".equals(i.getSupAccountGroup())).collect(Collectors.toList());
        for (Company company : coms) {
            List<String> codeList = this.findCompanyCodeList();
            this.initBill(company.getCompanySapCode(), codeList, startTime, startTimeStr, endTime, endTimeStr);
        }
    }

    private List<Company> filter() {
        CompanyExample example = new CompanyExample();
        example.createCriteria().andIsEnableEqualTo(Constant.YES_INT);
        List companies = this.companyService.queryAllObjByExample((IExample)example);
        SupGroupExample supGroupExample = new SupGroupExample();
        supGroupExample.createCriteria().andIsEnableEqualTo(Constant.YES_INT).andSupGroupNameEqualTo("\u4e0d\u81ea\u52a8\u63a8\u9001");
        List grous = this.supGroupService.queryAllObjByExample((IExample)supGroupExample);
        if (CollectionUtils.isEmpty((Collection)grous)) {
            return companies;
        }
        List list = grous.stream().map(SupGroup::getSupCompanySapCode).collect(Collectors.toList());
        List<Company> list2 = companies.stream().filter(i -> list.stream().noneMatch(ll -> ll.equals(i.getCompanySapCode()))).collect(Collectors.toList());
        return list2;
    }

    @Override
    @Transactional
    @Cacheable(value={"bill"}, keyGenerator="redisKeyGenerator")
    public void createBillC006() throws ParseException {
        String startTimeStr = "2018-07-01";
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Date startTime = this.getStartTime(format, startTimeStr);
        Date endTime = new Date();
        String endTimeStr = DateFormatUtils.format((Date)endTime, (String)"yyyy-MM-dd");
        List<Company> companies = this.filter();
        List coms = companies.stream().filter(i -> "C006".equals(i.getSupAccountGroup())).collect(Collectors.toList());
        for (Company company : coms) {
            List<String> codeList = this.findCompanyCodeList();
            this.initBill(company.getCompanySapCode(), codeList, startTime, startTimeStr, endTime, endTimeStr);
        }
    }

    private void initBill(String sapCode, List<String> codeList, Date startTime, String startTimeStr, Date endTime, String endTimeStr) throws ParseException {
        for (String companyCode : codeList) {
            Bill bill;
            List<BillVoucher> voucherList;
            List<BillVoucher> billVoucherList = this.voucherTimeTaskService.importByVoucherDate(companyCode, sapCode, startTimeStr, endTimeStr);
            this.logger.info(String.format("EVENT=\u5f00\u7968\u6e05\u5355\u5165\u53e3", new Object[0]));
            if (CollectionUtils.isEmpty(billVoucherList) || !CollectionUtils.isNotEmpty(voucherList = this.insertVoucherList(bill = this.assembleForTimeTask(companyCode, sapCode, billVoucherList, startTime, endTime), billVoucherList, startTime, endTime))) continue;
            CalculateBillUtil.calculateAmount(bill, voucherList);
            if (bill.getIncludeTaxAmount().compareTo(new BigDecimal(0)) == 0) {
                String dnos = bill.getSupUserName();
                if (StringUtils.isNotEmpty((String)dnos)) {
                    String[] strings;
                    for (String dno : strings = dnos.split(",")) {
                        DeductionExample example = new DeductionExample();
                        example.createCriteria().andDeductionNoEqualTo(dno).andIsEnableEqualTo(Constant.YES_INT);
                        List deductions = this.deductionService.queryAllObjByExample((IExample)example);
                        if (!CollectionUtils.isNotEmpty((Collection)deductions)) continue;
                        for (Deduction deduction : deductions) {
                            deduction.setId(deduction.getId());
                            deduction.setBillFlag(Constant.NO_INT);
                            this.deductionService.modifyObj(deduction);
                        }
                    }
                }
                this.sapBillService.deductionBackSap(bill);
                BillItemExample billItemExample = new BillItemExample();
                billItemExample.createCriteria().andBillIdEqualTo(bill.getId());
                List billItems = this.billItemService.queryAllObjByExample((IExample)billItemExample);
                billItems.forEach(i -> {
                    this.billItemService.deleteObjById(i.getId());
                    this.billVoucherService.deleteObjById(i.getVoucherId());
                });
                continue;
            }
            this.billService.addObj(bill);
            this.billService.updateByPrimaryKeySelective(bill);
            this.voucherTimeTaskService.deductionBackSap(bill);
            this.sendMessagesToSup(bill, BillBusinessTypeEnum.BILL_SEND.getCode());
        }
    }

    protected void sendMessagesToSup(Bill data, String businessType) {
        User supUser = this.companyUserRefService.queryMainUserOfCompany(data.getSupCompanyId());
        String supUserId = null;
        supUserId = StringUtils.isEmpty((String)data.getSupUserId()) ? supUser.getId() : data.getSupUserId();
        Message message = Message.init((Object)data).setBusinessTypeCode(businessType).setCompanyCode(data.getPurCompanySrmCode()).setMsgLevel(MessageLevelEnum.HIGH).setSenderId("1").addReceiverId(supUserId);
        MessageSendUtils.sendMessage((Message)message);
    }

    private List<Organization> getOrganizations() {
        OrganizationExample ozExample = new OrganizationExample();
        ozExample.createCriteria().andOrganizationTypeEqualTo("T001");
        List organizations = this.organizationService.queryAllObjByExample((IExample)ozExample);
        return organizations;
    }

    private Date getStartTime(SimpleDateFormat format, String date) {
        Date startTime = null;
        try {
            startTime = format.parse(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return startTime;
    }

    private List<BillVoucher> insertVoucherList(Bill bill, List<BillVoucher> billVoucherList, Date startTime, Date endTime) {
        Set billVoucherTaxCodeSet = billVoucherList.stream().map(voucher -> voucher.getTaxCode()).collect(Collectors.toSet());
        if (billVoucherTaxCodeSet.size() != 1) {
            String date = "\u4f9b\u5e94\u5546:" + bill.getSupCompanyFullName() + ",\u516c\u53f8:" + bill.getCompanyCode() + "\u5165\u53c2\u533a\u95f4," + DateFormatUtils.format((Date)startTime, (String)"yyyy-MM-dd") + "-" + DateFormatUtils.format((Date)endTime, (String)"yyyy-MM-dd") + "\u751f\u6210\u5bf9\u8d26\u5355\u5931\u8d25:\u51ed\u8bc1\u7a0e\u7801\u4e0d\u540c";
            this.sendMessagesToPur(date, BillBusinessTypeEnum.BILL_FALSE_RESAON.getCode());
            return null;
        }
        List group = Lists.partition(billVoucherList, (int)999);
        for (List list : group) {
            this.updateBillVoucher(list, Constant.YES_INT);
        }
        this.insertVoucher(bill, billVoucherList);
        return billVoucherList;
    }

    private void insertVoucher(Bill bill, List<BillVoucher> billVoucherList) {
        Assert.isNotEmpty(billVoucherList, (String)"\u5f00\u7968\u6e05\u5355\u884c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        for (BillVoucher billVoucher : billVoucherList) {
            BillItem billItem = new BillItem();
            BeanUtils.copyProperties((Object)billVoucher, (Object)billItem);
            billItem.setId(null);
            billItem.setBillId(bill.getId());
            billItem.setBillNo(bill.getBillNo());
            billItem.setBillFlag(Constant.YES_INT);
            billItem.setIsEnable(Constant.YES_INT);
            billItem.setVoucherId(billVoucher.getId());
            billItem.setBillInvoiceFlag(Constant.NO_INT);
            this.billItemService.addObj(billItem);
        }
    }

    private void updateBillVoucher(List<BillVoucher> voucherList, int billFlag) {
        if (CollectionUtils.isNotEmpty(voucherList)) {
            List ids = voucherList.stream().map(billVoucher -> billVoucher.getId()).collect(Collectors.toList());
            BillVoucherExample billVoucherExample = new BillVoucherExample();
            billVoucherExample.createCriteria().andIdIn(ids);
            BillVoucher billVoucher2 = new BillVoucher();
            billVoucher2.setBillFlag(billFlag);
            billVoucher2.setIsLatest(Constant.NO_INT);
            this.billVoucherService.updateByExampleSelective(billVoucher2, billVoucherExample);
        }
    }

    protected void sendMessagesToPur(String date, String businessType) {
        Message message = Message.init((Object)date).setBusinessTypeCode(businessType).setCompanyCode("51000000").setMsgLevel(MessageLevelEnum.HIGH).addReceiverId("20180704105632-e13655014dce400b9");
        MessageSendUtils.sendMessage((Message)message);
    }

    private Bill assembleForTimeTask(String companyCode, String supCompanySapCode, List<BillVoucher> billVoucherList, Date postingStartTime, Date postingEndTime) {
        Bill bill = new Bill();
        bill.setCompanyCode(companyCode);
        Company purCompany = (Company)this.companyService.queryObjById((Object)"20170623111117-7147d39a28ad40e8a");
        Assert.isNotNull((Object)purCompany, (String)"\u91c7\u8d2d\u57fa\u672c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        bill.setId(UUIDGenerator.generateUUID());
        bill.setPurCompanyId(purCompany.getId());
        bill.setPurCompanySrmCode(purCompany.getCompanyCode());
        bill.setPurCompanySapCode(purCompany.getCompanySapCode());
        bill.setPurCompanyName(purCompany.getCompanyName());
        bill.setPurCompanyFullName(purCompany.getCompanyFullName());
        this.setSupCompanyInfo(supCompanySapCode, bill);
        OrganizationExample ozExample = new OrganizationExample();
        ozExample.createCriteria().andOrganizationTypeEqualTo("T001").andCodeEqualTo(companyCode);
        List organizations = this.organizationService.queryAllObjByExample((IExample)ozExample);
        String description = ((Organization)organizations.get(0)).getDescription();
        Assert.isNotEmpty((Collection)organizations, (String)("\u516c\u53f8\u4ee3\u7801" + companyCode + "\u672a\u5728\u7cfb\u7edf\u7ef4\u62a4"));
        bill.setCompanyName(description);
        bill.setPostingStartTime(postingStartTime);
        bill.setPostingEndTime(postingEndTime);
        bill.setCreateTime(new Date());
        String comp = billVoucherList.get(0).getCompany();
        String no = this.getNo(bill, comp, supCompanySapCode);
        bill.setBillNo(no);
        bill.setPurUserId("1");
        bill.setPurUserName("\u8d85\u7ea7\u7ba1\u7406\u5458");
        bill.setIsEnable(Constant.YES_INT);
        bill.setPurSendStatus(BillSendStatus.YES_INT);
        bill.setSupConfirmStatus(BillStatusConfirmEnum.STATUS_UNCONFIRM.getConfirmStatus());
        bill.setSupConfirmBillStatus(Constant.NO_INT);
        bill.setSupSendStatus(BillSendStatus.NO);
        bill.setPurConfirmStatus(BillStatusConfirmEnum.STATUS_CONFIRM.getConfirmStatus());
        bill.setPurConfirmBillStatus(BillSendStatus.NO_INT);
        bill.setAbolishStatus(Constant.NO_INT);
        bill.setTaxCode(billVoucherList.get(0).getTaxCode());
        CalculateBillUtil.calculateAmount(bill, billVoucherList);
        DeductionExample example = new DeductionExample();
        example.createCriteria().andCompanyCodeEqualTo(bill.getCompanyCode()).andSupCompanyIdEqualTo(bill.getSupCompanyId()).andIsEnableEqualTo(Constant.YES_INT).andBillFlagEqualTo(Constant.NO_INT);
        List deductions = this.deductionService.queryAllObjByExample((IExample)example);
        if (CollectionUtils.isEmpty((Collection)deductions)) {
            bill.setDeductionAmount(new BigDecimal(0));
        } else {
            BigDecimal big = new BigDecimal(0);
            StringBuilder stringBuilder = new StringBuilder();
            for (Deduction deduction : deductions) {
                big = big.add(deduction.getDeductionAmount());
                stringBuilder.append(deduction.getDeductionNo()).append(",");
                Deduction de = new Deduction();
                de.setId(deduction.getId());
                de.setBillFlag(Constant.YES_INT);
                this.deductionService.modifyObj(de);
            }
            String substring = stringBuilder.substring(0, stringBuilder.length() - 1);
            bill.setDeductionAmount(big);
            bill.setApproveResult(substring);
        }
        return bill;
    }

    private void setSupCompanyInfo(String supCompanySapCode, Bill bill) {
        Company supCompany = this.companyService.queryCompanyBySapCode(supCompanySapCode);
        Assert.isNotNull((Object)supCompany, (String)"\u4f9b\u5e94\u5546\u4e0d\u5b58\u5728\uff0c\u8bf7\u5728\u4e3b\u6570\u636e\u7ef4\u62a4\uff0c\u8c22\u8c22\uff01");
        bill.setSupCompanyId(supCompany.getId());
        bill.setSupCompanySrmCode(supCompany.getCompanyCode());
        bill.setSupCompanySapCode(supCompanySapCode);
        bill.setSupCompanyName(supCompany.getCompanyName());
        bill.setSupCompanyFullName(supCompany.getCompanyFullName());
        bill.setSupComtactTelephone(supCompany.getTelephone());
        bill.setSupComtactUserName(supCompany.getContacts());
        bill.setSupCompanyAddress(supCompany.getAddress());
        bill.setPayConditionsCode(supCompany.getPayConditionsCode());
        bill.setPayConditionsDesc(supCompany.getPayConditionsDesc());
    }

    private String getNo(Bill bill, String comp, String supCompanySapCode) {
        String dateTime = DateFormatUtils.format((Date)bill.getCreateTime(), (String)"yyMM");
        String li = supCompanySapCode.substring(supCompanySapCode.length() - 4, supCompanySapCode.length());
        BillExample billExample = new BillExample();
        billExample.createCriteria().andBillNoLike(dateTime + comp + li + "%");
        int i = this.billService.countByExample(billExample);
        return String.format("%s%s%s%02d", dateTime, comp, li, i + 1);
    }

    private List<String> findCompanyCodeList() {
        ArrayList companyCodeList = Lists.newArrayList();
        companyCodeList.add("1010");
        companyCodeList.add("1020");
        companyCodeList.add("1030");
        companyCodeList.add("1040");
        companyCodeList.add("1050");
        companyCodeList.add("1060");
        companyCodeList.add("1080");
        companyCodeList.add("1100");
        companyCodeList.add("1140");
        companyCodeList.add("1160");
        companyCodeList.add("1190");
        companyCodeList.add("9610");
        companyCodeList.add("5600");
        companyCodeList.add("6010");
        companyCodeList.add("9000");
        companyCodeList.add("9100");
        companyCodeList.add("9200");
        companyCodeList.add("9300");
        companyCodeList.add("8000");
        companyCodeList.add("1200");
        return companyCodeList;
    }
}

