/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.dealings.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.dealings.dao.BillDealingsMapper;
import com.els.base.dealings.entity.BillDealings;
import com.els.base.dealings.entity.BillDealingsExample;
import com.els.base.dealings.service.BillDealingsService;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultBillDealingsService")
public class BillDealingsServiceImpl
implements BillDealingsService {
    @Resource
    protected BillDealingsMapper billDealingsMapper;

    @CacheEvict(value={"billDealings"}, allEntries=true)
    public void addObj(BillDealings t) {
        this.billDealingsMapper.insertSelective(t);
    }

    @CacheEvict(value={"billDealings"}, allEntries=true)
    public void deleteObjById(String id) {
        this.billDealingsMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"billDealings"}, allEntries=true)
    public void modifyObj(BillDealings t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.billDealingsMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"billDealings"}, keyGenerator="redisKeyGenerator")
    public BillDealings queryObjById(String id) {
        return this.billDealingsMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"billDealings"}, keyGenerator="redisKeyGenerator")
    public List<BillDealings> queryAllObjByExample(BillDealingsExample example) {
        return this.billDealingsMapper.selectByExample(example);
    }

    @Cacheable(value={"billDealings"}, keyGenerator="redisKeyGenerator")
    public PageView<BillDealings> queryObjByPage(BillDealingsExample example) {
        PageView<BillDealings> pageView = example.getPageView();
        pageView.setQueryResult(this.billDealingsMapper.selectByExampleByPage(example));
        return pageView;
    }

    @CacheEvict(value={"billDealings"}, allEntries=true)
    public void deleteByExample(BillDealingsExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.billDealingsMapper.deleteByExample(example);
    }

    @CacheEvict(value={"billDealings"}, allEntries=true)
    @Transactional
    public void addAll(List<BillDealings> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(record -> this.billDealingsMapper.insertSelective((BillDealings)record));
    }
}

