/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.voucher.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.utils.uuid.UUIDGenerator;
import com.els.base.voucher.dao.BillVoucherMapper;
import com.els.base.voucher.entity.BillVoucher;
import com.els.base.voucher.entity.BillVoucherExample;
import com.els.base.voucher.service.BillVoucherService;
import com.els.base.voucher.utils.BillVoucherEnum;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultBillVoucherService")
public class BillVoucherServiceImpl
implements BillVoucherService {
    @Resource
    protected BillVoucherMapper billVoucherMapper;

    @Override
    @Cacheable(value={"billVoucher"}, keyGenerator="redisKeyGenerator")
    @Transactional
    public int countByExample(BillVoucherExample example) {
        return this.billVoucherMapper.countByExample(example);
    }

    @Override
    @CacheEvict(value={"billVoucher"}, allEntries=true)
    @Transactional
    public int updateByExampleSelective(BillVoucher record, BillVoucherExample example) {
        return this.billVoucherMapper.updateByExampleSelective(record, example);
    }

    @Override
    @Cacheable(value={"billVoucher"}, keyGenerator="redisKeyGenerator")
    public List<BillVoucher> queryAllBillVoucher(String companyCode, String supCompanySapCode, Date startTime, Date endTime, List<String> ids) {
        BillVoucherExample example = new BillVoucherExample();
        BillVoucherExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT).andIsLatestEqualTo(Constant.YES_INT);
        if (CollectionUtils.isNotEmpty(ids)) {
            criteria.andIdNotIn((List)ids);
        }
        return this.billVoucherMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"billVoucher"}, keyGenerator="redisKeyGenerator")
    public List<BillVoucher> queryAllRebateVoucher(String supCompanySapCode, Date startTime, Date endTime, List<BillVoucher> billVoucherList) {
        ArrayList<BillVoucher> voucherList = new ArrayList<BillVoucher>();
        if (CollectionUtils.isEmpty(billVoucherList)) {
            return voucherList;
        }
        this.findByPageFilter(supCompanySapCode, startTime, endTime);
        ArrayList<String> billType = new ArrayList<String>();
        billType.add(BillVoucherEnum.REBATE.getCode());
        for (BillVoucher billVoucher : billVoucherList) {
            BillVoucherExample example = new BillVoucherExample();
            BillVoucherExample.Criteria criteria = example.createCriteria();
            criteria.andIsEnableEqualTo(Constant.YES_INT).andBillFlagEqualTo(Constant.NO_INT).andSupCompanySapCodeEqualTo(supCompanySapCode).andPostingTimeBetween(startTime, endTime).andBillTypeIn(billType).andMaterialVoucherNoEqualTo(billVoucher.getMaterialVoucherNo()).andMaterialVoucherItemNoEqualTo(billVoucher.getMaterialVoucherItemNo());
            List<BillVoucher> voucherList1 = this.billVoucherMapper.selectByExample(example);
            if (!CollectionUtils.isNotEmpty(voucherList1)) continue;
            voucherList.addAll(voucherList1);
        }
        return voucherList;
    }

    @Override
    public void findByPageFilter(String supCompanySapCode, Date startPostingTime, Date endPostingTime) {
        Assert.isNotBlank((String)supCompanySapCode, (String)"\u4f9b\u5e94\u5546\u7684SAP\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.isNotNull((Object)startPostingTime, (String)"\u51ed\u8bc1\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.isNotNull((Object)endPostingTime, (String)"\u51ed\u8bc1\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
    }

    @CacheEvict(value={"billVoucher"}, allEntries=true)
    public void addObj(BillVoucher t) {
        this.billVoucherMapper.insertSelective(t);
    }

    @CacheEvict(value={"billVoucher"}, allEntries=true)
    public void deleteObjById(String id) {
        this.billVoucherMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"billVoucher"}, allEntries=true)
    public void modifyObj(BillVoucher t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.billVoucherMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"billVoucher"}, keyGenerator="redisKeyGenerator")
    public BillVoucher queryObjById(String id) {
        return this.billVoucherMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"billVoucher"}, keyGenerator="redisKeyGenerator")
    public List<BillVoucher> queryAllObjByExample(BillVoucherExample example) {
        return this.billVoucherMapper.selectByExample(example);
    }

    @Cacheable(value={"billVoucher"}, keyGenerator="redisKeyGenerator")
    public PageView<BillVoucher> queryObjByPage(BillVoucherExample example) {
        PageView<BillVoucher> pageView = example.getPageView();
        pageView.setQueryResult(this.billVoucherMapper.selectByExampleByPage(example));
        return pageView;
    }

    @CacheEvict(value={"billVoucher"}, allEntries=true)
    public void deleteByExample(BillVoucherExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.billVoucherMapper.deleteByExample(example);
    }

    @CacheEvict(value={"billVoucher"}, allEntries=true)
    @Transactional
    public void addAll(List<BillVoucher> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(record -> record.setId(UUIDGenerator.generateUUID()));
        this.billVoucherMapper.insertBatch(list);
    }
}

