/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.accountGroup.service.impl;

import com.els.base.accountGroup.dao.SupGroupMapper;
import com.els.base.accountGroup.entity.SupGroup;
import com.els.base.accountGroup.entity.SupGroupExample;
import com.els.base.accountGroup.service.SupGroupService;
import com.els.base.company.entity.Company;
import com.els.base.company.service.CompanyService;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultSupGroupService")
public class SupGroupServiceImpl
implements SupGroupService {
    @Resource
    protected SupGroupMapper supGroupMapper;
    @Resource
    protected CompanyService companyService;

    @CacheEvict(value={"supGroup"}, allEntries=true)
    public void addObj(SupGroup t) {
        this.supGroupMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"supGroup"}, allEntries=true)
    public void addAll(List<SupGroup> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.supGroupMapper.insertBatch(list);
    }

    @CacheEvict(value={"supGroup"}, allEntries=true)
    public void deleteObjById(String id) {
        this.supGroupMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"supGroup"}, allEntries=true)
    public void deleteByExample(SupGroupExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.supGroupMapper.deleteByExample(example);
    }

    @CacheEvict(value={"supGroup"}, allEntries=true)
    public void modifyObj(SupGroup t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.supGroupMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"supGroup"}, keyGenerator="redisKeyGenerator")
    public SupGroup queryObjById(String id) {
        return this.supGroupMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"supGroup"}, keyGenerator="redisKeyGenerator")
    public List<SupGroup> queryAllObjByExample(SupGroupExample example) {
        return this.supGroupMapper.selectByExample(example);
    }

    @Cacheable(value={"supGroup"}, keyGenerator="redisKeyGenerator")
    public PageView<SupGroup> queryObjByPage(SupGroupExample example) {
        PageView<SupGroup> pageView = example.getPageView();
        pageView.setQueryResult(this.supGroupMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @Transactional
    @CacheEvict(value={"supGroup"}, allEntries=true)
    public void insert(SupGroup supGroup, User user, Company company) {
        Assert.isNotBlank((String)supGroup.getSupGroupName(), (String)"\u7ec4\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)supGroup.getSupCompanySapCode(), (String)"\u4f9b\u5e94\u5546\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        String sapCode = supGroup.getSupCompanySapCode();
        SupGroupExample example = new SupGroupExample();
        example.createCriteria().andIsEnableEqualTo(Constant.YES_INT);
        List<SupGroup> list = this.supGroupMapper.selectByExample(example);
        int j = 0;
        if (sapCode.contains(",")) {
            String[] split;
            for (String string : split = sapCode.split(",")) {
                List list2 = list.stream().filter(i -> string.equals(i.getSupCompanySapCode())).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(list2)) continue;
                this.complete(supGroup, user, company);
                this.completeSupInfo(supGroup, string);
                this.addObj(supGroup);
                ++j;
            }
            if (j == 0) {
                throw new CommonException("\u9009\u62e9\u4f9b\u5e94\u5546\u5168\u90e8\u5df2\u5206\u7ec4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\uff01");
            }
        } else {
            List list2 = list.stream().filter(i -> supGroup.getSupCompanySapCode().equals(i.getSupCompanySapCode())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(list2)) {
                throw new CommonException("\u4f9b\u5e94\u5546\uff1a" + supGroup.getSupCompanySapCode() + "\u5df2\u5b58\u5728,\u4e0d\u5141\u8bb8\u91cd\u590d\u6dfb\u52a0\uff01");
            }
            this.complete(supGroup, user, company);
            this.completeSupInfo(supGroup, supGroup.getSupCompanySapCode());
            this.addObj(supGroup);
        }
    }

    private void completeSupInfo(SupGroup supGroup, String supCompanySapCode) {
        Company company = this.companyService.queryCompanyBySapCode(supCompanySapCode);
        supGroup.setSupCompanyId(company.getId());
        supGroup.setSupCompanyFullName(company.getCompanyFullName());
        supGroup.setSupCompanyName(company.getCompanyName());
        supGroup.setSupCompanySapCode(company.getCompanySapCode());
        supGroup.setSupCompanySrmCode(company.getCompanyCode());
    }

    private void complete(SupGroup supGroup, User user, Company company) {
        supGroup.setIsEnable(Constant.YES_INT);
        supGroup.setId(UUIDGenerator.generateUUID());
        supGroup.setCreateTime(new Date());
        supGroup.setCreateUser(user.getNickName());
        supGroup.setPurCompanyFullName(company.getCompanyFullName());
        supGroup.setPurCompanyId(company.getId());
        supGroup.setPurCompanyName(company.getCompanyName());
        supGroup.setPurCompanySapCode(company.getCompanySapCode());
        supGroup.setPurCompanySrmCode(company.getCompanyCode());
    }

    @Override
    @Transactional
    @CacheEvict(value={"supGroup"}, allEntries=true)
    public void deleteByIds(List<String> ids, User loginUser) {
        SupGroupExample example = new SupGroupExample();
        example.createCriteria().andIdIn((List)ids);
        SupGroup group = new SupGroup();
        group.setIsEnable(Constant.NO_INT);
        group.setUpdateTime(new Date());
        group.setUpdateUser(loginUser.getNickName());
        this.supGroupMapper.updateByExampleSelective(group, example);
    }

    @Override
    @Transactional
    @CacheEvict(value={"supGroup"}, allEntries=true)
    public void modify(SupGroup supGroup, User loginUser, Company company) {
        this.supGroupMapper.deleteByPrimaryKey(supGroup.getId());
        this.insert(supGroup, loginUser, company);
    }
}

